/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.x509;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERGeneralizedTime;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.DERTaggedObject;
import info.guardianproject.bouncycastle.asn1.x509.X509Extension;
import java.util.Enumeration;

public class PrivateKeyUsagePeriod
extends ASN1Encodable {
    private DERGeneralizedTime _notBefore;
    private DERGeneralizedTime _notAfter;

    public static PrivateKeyUsagePeriod getInstance(Object obj) {
        if (obj instanceof PrivateKeyUsagePeriod) {
            return (PrivateKeyUsagePeriod)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PrivateKeyUsagePeriod((ASN1Sequence)obj);
        }
        if (obj instanceof X509Extension) {
            return PrivateKeyUsagePeriod.getInstance(X509Extension.convertValueToObject((X509Extension)obj));
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    private PrivateKeyUsagePeriod(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this._notBefore = DERGeneralizedTime.getInstance(tObj, false);
                continue;
            }
            if (tObj.getTagNo() != 1) continue;
            this._notAfter = DERGeneralizedTime.getInstance(tObj, false);
        }
    }

    public DERGeneralizedTime getNotBefore() {
        return this._notBefore;
    }

    public DERGeneralizedTime getNotAfter() {
        return this._notAfter;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this._notBefore != null) {
            v.add(new DERTaggedObject(false, 0, this._notBefore));
        }
        if (this._notAfter != null) {
            v.add(new DERTaggedObject(false, 1, this._notAfter));
        }
        return new DERSequence(v);
    }
}

