/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.bcpg;

import info.guardianproject.bouncycastle.bcpg.BCPGInputStream;
import info.guardianproject.bouncycastle.bcpg.BCPGKey;
import info.guardianproject.bouncycastle.bcpg.BCPGObject;
import info.guardianproject.bouncycastle.bcpg.BCPGOutputStream;
import info.guardianproject.bouncycastle.bcpg.MPInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class RSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger n;
    MPInteger e;

    public RSAPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.n = new MPInteger(in);
        this.e = new MPInteger(in);
    }

    public RSAPublicBCPGKey(BigInteger n, BigInteger e) {
        this.n = new MPInteger(n);
        this.e = new MPInteger(e);
    }

    public BigInteger getPublicExponent() {
        return this.e.getValue();
    }

    public BigInteger getModulus() {
        return this.n.getValue();
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pgpOut = new BCPGOutputStream(bOut);
            pgpOut.writeObject(this);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.n);
        out.writeObject(this.e);
    }
}

