/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.bcpg;

import info.guardianproject.bouncycastle.bcpg.SignatureSubpacket;
import info.guardianproject.bouncycastle.bcpg.SignatureSubpacketTags;
import info.guardianproject.bouncycastle.bcpg.sig.Exportable;
import info.guardianproject.bouncycastle.bcpg.sig.IssuerKeyID;
import info.guardianproject.bouncycastle.bcpg.sig.KeyExpirationTime;
import info.guardianproject.bouncycastle.bcpg.sig.KeyFlags;
import info.guardianproject.bouncycastle.bcpg.sig.NotationData;
import info.guardianproject.bouncycastle.bcpg.sig.PreferredAlgorithms;
import info.guardianproject.bouncycastle.bcpg.sig.PrimaryUserID;
import info.guardianproject.bouncycastle.bcpg.sig.Revocable;
import info.guardianproject.bouncycastle.bcpg.sig.SignatureCreationTime;
import info.guardianproject.bouncycastle.bcpg.sig.SignatureExpirationTime;
import info.guardianproject.bouncycastle.bcpg.sig.SignerUserID;
import info.guardianproject.bouncycastle.bcpg.sig.TrustSignature;
import info.guardianproject.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    InputStream in;

    public SignatureSubpacketInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        int l = this.read();
        int bodyLen = 0;
        if (l < 0) {
            return null;
        }
        if (l < 192) {
            bodyLen = l;
        } else if (l <= 223) {
            bodyLen = (l - 192 << 8) + this.in.read() + 192;
        } else if (l == 255) {
            bodyLen = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        }
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        if (Streams.readFully(this.in, data) < data.length) {
            throw new EOFException();
        }
        boolean isCritical = (tag & 0x80) != 0;
        int type = tag & 0x7F;
        switch (type) {
            case 2: {
                return new SignatureCreationTime(isCritical, data);
            }
            case 9: {
                return new KeyExpirationTime(isCritical, data);
            }
            case 3: {
                return new SignatureExpirationTime(isCritical, data);
            }
            case 7: {
                return new Revocable(isCritical, data);
            }
            case 4: {
                return new Exportable(isCritical, data);
            }
            case 16: {
                return new IssuerKeyID(isCritical, data);
            }
            case 5: {
                return new TrustSignature(isCritical, data);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(type, isCritical, data);
            }
            case 27: {
                return new KeyFlags(isCritical, data);
            }
            case 25: {
                return new PrimaryUserID(isCritical, data);
            }
            case 28: {
                return new SignerUserID(isCritical, data);
            }
            case 20: {
                return new NotationData(isCritical, data);
            }
        }
        return new SignatureSubpacket(type, isCritical, data);
    }
}

