/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.agreement;

import info.guardianproject.bouncycastle.crypto.BasicAgreement;
import info.guardianproject.bouncycastle.crypto.CipherParameters;
import info.guardianproject.bouncycastle.crypto.params.ECDomainParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPublicKeyParameters;
import info.guardianproject.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECDomainParameters params = pub.getParameters();
        ECPoint P = pub.getQ().multiply(params.getH().multiply(this.key.getD()));
        return P.getX().toBigInteger();
    }
}

