/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.agreement.kdf;

import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.DERObjectIdentifier;
import info.guardianproject.bouncycastle.asn1.DEROctetString;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.DERTaggedObject;
import info.guardianproject.bouncycastle.crypto.DataLengthException;
import info.guardianproject.bouncycastle.crypto.DerivationFunction;
import info.guardianproject.bouncycastle.crypto.DerivationParameters;
import info.guardianproject.bouncycastle.crypto.Digest;
import info.guardianproject.bouncycastle.crypto.agreement.kdf.DHKDFParameters;

public class DHKEKGenerator
implements DerivationFunction {
    private final Digest digest;
    private DERObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;
    private byte[] partyAInfo;

    public DHKEKGenerator(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
        this.partyAInfo = params.getExtraInfo();
    }

    @Override
    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new DataLengthException("output buffer too small");
        }
        long oBytes = len;
        int outLen = this.digest.getDigestSize();
        if (oBytes > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int cThreshold = (int)((oBytes + (long)outLen - 1L) / (long)outLen);
        byte[] dig = new byte[this.digest.getDigestSize()];
        int counter = 1;
        int i = 0;
        while (i < cThreshold) {
            this.digest.update(this.z, 0, this.z.length);
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(this.algorithm);
            v2.add(new DEROctetString(this.integerToBytes(counter)));
            v1.add(new DERSequence(v2));
            if (this.partyAInfo != null) {
                v1.add(new DERTaggedObject(true, 0, new DEROctetString(this.partyAInfo)));
            }
            v1.add(new DERTaggedObject(true, 2, new DEROctetString(this.integerToBytes(this.keySize))));
            byte[] other = new DERSequence(v1).getDEREncoded();
            this.digest.update(other, 0, other.length);
            this.digest.doFinal(dig, 0);
            if (len > outLen) {
                System.arraycopy(dig, 0, out, outOff, outLen);
                outOff += outLen;
                len -= outLen;
            } else {
                System.arraycopy(dig, 0, out, outOff, len);
            }
            ++counter;
            ++i;
        }
        this.digest.reset();
        return len;
    }

    private byte[] integerToBytes(int keySize) {
        byte[] val = new byte[]{(byte)(keySize >> 24), (byte)(keySize >> 16), (byte)(keySize >> 8), (byte)keySize};
        return val;
    }
}

