/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.signers;

import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Object;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.DERInteger;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.crypto.CipherParameters;
import info.guardianproject.bouncycastle.crypto.DSA;
import info.guardianproject.bouncycastle.crypto.Digest;
import info.guardianproject.bouncycastle.crypto.Signer;
import info.guardianproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import info.guardianproject.bouncycastle.crypto.params.ParametersWithRandom;
import java.io.IOException;
import java.math.BigInteger;

public class DSADigestSigner
implements Signer {
    private final Digest digest;
    private final DSA dsaSigner;
    private boolean forSigning;

    public DSADigestSigner(DSA signer, Digest digest) {
        this.digest = digest;
        this.dsaSigner = signer;
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter k = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !k.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && k.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.dsaSigner.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
        this.digest.update(input);
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.digest.update(input, inOff, length);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for signature generation.");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        BigInteger[] sig = this.dsaSigner.generateSignature(hash);
        return this.derEncode(sig[0], sig[1]);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for verification");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.derDecode(signature);
            return this.dsaSigner.verifySignature(hash, sig[0], sig[1]);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    private byte[] derEncode(BigInteger r, BigInteger s) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(r));
        v.add(new DERInteger(s));
        return new DERSequence(v).getDEREncoded();
    }

    private BigInteger[] derDecode(byte[] encoding) throws IOException {
        ASN1Sequence s = (ASN1Sequence)ASN1Object.fromByteArray(encoding);
        return new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
    }
}

