/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.Digest;
import info.guardianproject.bouncycastle.crypto.digests.MD5Digest;
import info.guardianproject.bouncycastle.crypto.digests.SHA1Digest;

class CombinedHash
implements Digest {
    private MD5Digest md5;
    private SHA1Digest sha1;

    CombinedHash() {
        this.md5 = new MD5Digest();
        this.sha1 = new SHA1Digest();
    }

    CombinedHash(CombinedHash t) {
        this.md5 = new MD5Digest(t.md5);
        this.sha1 = new SHA1Digest(t.sha1);
    }

    @Override
    public String getAlgorithmName() {
        return String.valueOf(this.md5.getAlgorithmName()) + " and " + this.sha1.getAlgorithmName() + " for TLS 1.0";
    }

    @Override
    public int getDigestSize() {
        return 36;
    }

    @Override
    public void update(byte in) {
        this.md5.update(in);
        this.sha1.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.md5.update(in, inOff, len);
        this.sha1.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int i1 = this.md5.doFinal(out, outOff);
        int i2 = this.sha1.doFinal(out, outOff + 16);
        return i1 + i2;
    }

    @Override
    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

