/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import info.guardianproject.bouncycastle.crypto.tls.TlsCipher;
import info.guardianproject.bouncycastle.crypto.tls.TlsCipherFactory;
import info.guardianproject.bouncycastle.crypto.tls.TlsClient;
import info.guardianproject.bouncycastle.crypto.tls.TlsClientContext;
import info.guardianproject.bouncycastle.crypto.tls.TlsCompression;
import info.guardianproject.bouncycastle.crypto.tls.TlsDHEKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsDHKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsECDHEKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import info.guardianproject.bouncycastle.crypto.tls.TlsKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsNullCompression;
import info.guardianproject.bouncycastle.crypto.tls.TlsRSAKeyExchange;
import java.io.IOException;
import java.util.Hashtable;

public abstract class DefaultTlsClient
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsClientContext context;
    protected int selectedCipherSuite;
    protected int selectedCompressionMethod;

    public DefaultTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public DefaultTlsClient(TlsCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10};
    }

    @Override
    public Hashtable getClientExtensions() {
        return null;
    }

    @Override
    public short[] getCompressionMethods() {
        return new short[1];
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    @Override
    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) {
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 10: 
            case 47: 
            case 53: {
                return this.createRSAKeyExchange();
            }
            case 13: 
            case 48: 
            case 54: {
                return this.createDHKeyExchange(7);
            }
            case 16: 
            case 49: 
            case 55: {
                return this.createDHKeyExchange(9);
            }
            case 19: 
            case 50: 
            case 56: {
                return this.createDHEKeyExchange(3);
            }
            case 22: 
            case 51: 
            case 57: {
                return this.createDHEKeyExchange(5);
            }
            case 49155: 
            case 49156: 
            case 49157: {
                return this.createECDHKeyExchange(16);
            }
            case 49160: 
            case 49161: 
            case 49162: {
                return this.createECDHEKeyExchange(17);
            }
            case 49165: 
            case 49166: 
            case 49167: {
                return this.createECDHKeyExchange(18);
            }
            case 49170: 
            case 49171: 
            case 49172: {
                return this.createECDHEKeyExchange(19);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) {
        return new TlsDHKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) {
        return new TlsDHEKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) {
        return new TlsECDHKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) {
        return new TlsECDHEKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.context);
    }
}

