/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.tls.Certificate;
import info.guardianproject.bouncycastle.crypto.tls.CertificateRequest;
import info.guardianproject.bouncycastle.crypto.tls.CertificateVerifyer;
import info.guardianproject.bouncycastle.crypto.tls.TlsAuthentication;
import info.guardianproject.bouncycastle.crypto.tls.TlsCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class LegacyTlsAuthentication
implements TlsAuthentication {
    protected CertificateVerifyer verifyer;

    public LegacyTlsAuthentication(CertificateVerifyer verifyer) {
        this.verifyer = verifyer;
    }

    @Override
    public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
        if (!this.verifyer.isValid(serverCertificate.getCerts())) {
            throw new TlsFatalAlert(90);
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        return null;
    }
}

