/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import info.guardianproject.bouncycastle.asn1.x509.X509CertificateStructure;
import info.guardianproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import info.guardianproject.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import info.guardianproject.bouncycastle.crypto.generators.ECKeyPairGenerator;
import info.guardianproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import info.guardianproject.bouncycastle.crypto.params.ECDomainParameters;
import info.guardianproject.bouncycastle.crypto.params.ECKeyGenerationParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPublicKeyParameters;
import info.guardianproject.bouncycastle.crypto.tls.Certificate;
import info.guardianproject.bouncycastle.crypto.tls.CertificateRequest;
import info.guardianproject.bouncycastle.crypto.tls.TlsAgreementCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsClientContext;
import info.guardianproject.bouncycastle.crypto.tls.TlsCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsECDSASigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import info.guardianproject.bouncycastle.crypto.tls.TlsKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsRSASigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsSigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsSignerCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsUtils;
import info.guardianproject.bouncycastle.crypto.util.PublicKeyFactory;
import info.guardianproject.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class TlsECDHKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsSigner tlsSigner;
    protected AsymmetricKeyParameter serverPublicKey;
    protected ECPublicKeyParameters ecAgreeServerPublicKey;
    protected TlsAgreementCredentials agreementCredentials;
    protected ECPrivateKeyParameters ecAgreeClientPrivateKey = null;

    TlsECDHKeyExchange(TlsClientContext context, int keyExchange) {
        switch (keyExchange) {
            case 19: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 17: {
                this.tlsSigner = new TlsECDSASigner();
                break;
            }
            case 16: 
            case 18: {
                this.tlsSigner = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = context;
        this.keyExchange = keyExchange;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (this.tlsSigner == null) {
            try {
                this.ecAgreeServerPublicKey = this.validateECPublicKey((ECPublicKeyParameters)this.serverPublicKey);
            }
            catch (ClassCastException e) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 8);
        } else {
            if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 128);
        }
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: 
                case 65: 
                case 66: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
            ++i;
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
        this.agreementCredentials = null;
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (clientCredentials instanceof TlsAgreementCredentials) {
            this.agreementCredentials = (TlsAgreementCredentials)clientCredentials;
        } else if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        if (this.agreementCredentials != null) {
            TlsUtils.writeUint24(0, os);
        } else {
            this.generateEphemeralClientKeyExchange(this.ecAgreeServerPublicKey.getParameters(), os);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.ecAgreeServerPublicKey);
        }
        return this.calculateECDHBasicAgreement(this.ecAgreeServerPublicKey, this.ecAgreeClientPrivateKey);
    }

    protected boolean areOnSameCurve(ECDomainParameters a, ECDomainParameters b) {
        return a.getCurve().equals(b.getCurve()) && a.getG().equals(b.getG()) && a.getN().equals(b.getN()) && a.getH().equals(b.getH());
    }

    protected byte[] externalizeKey(ECPublicKeyParameters keyParameters) throws IOException {
        return keyParameters.getQ().getEncoded();
    }

    protected AsymmetricCipherKeyPair generateECKeyPair(ECDomainParameters ecParams) {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keyGenerationParameters = new ECKeyGenerationParameters(ecParams, this.context.getSecureRandom());
        keyPairGenerator.init(keyGenerationParameters);
        return keyPairGenerator.generateKeyPair();
    }

    protected void generateEphemeralClientKeyExchange(ECDomainParameters ecParams, OutputStream os) throws IOException {
        AsymmetricCipherKeyPair ecAgreeClientKeyPair = this.generateECKeyPair(ecParams);
        this.ecAgreeClientPrivateKey = (ECPrivateKeyParameters)ecAgreeClientKeyPair.getPrivate();
        byte[] keData = this.externalizeKey((ECPublicKeyParameters)ecAgreeClientKeyPair.getPublic());
        TlsUtils.writeUint24(keData.length + 1, os);
        TlsUtils.writeOpaque8(keData, os);
    }

    protected byte[] calculateECDHBasicAgreement(ECPublicKeyParameters publicKey, ECPrivateKeyParameters privateKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreement = basicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(agreement);
    }

    protected ECPublicKeyParameters validateECPublicKey(ECPublicKeyParameters key) throws IOException {
        return key;
    }
}

