/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.math.ec;

import info.guardianproject.bouncycastle.asn1.x9.X9IntegerConverter;
import info.guardianproject.bouncycastle.math.ec.ECConstants;
import info.guardianproject.bouncycastle.math.ec.ECCurve;
import info.guardianproject.bouncycastle.math.ec.ECFieldElement;
import info.guardianproject.bouncycastle.math.ec.ECMultiplier;
import info.guardianproject.bouncycastle.math.ec.FpNafMultiplier;
import info.guardianproject.bouncycastle.math.ec.PreCompInfo;
import info.guardianproject.bouncycastle.math.ec.WNafMultiplier;
import info.guardianproject.bouncycastle.math.ec.WTauNafMultiplier;
import java.math.BigInteger;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;
    protected boolean withCompression;
    protected ECMultiplier multiplier = null;
    protected PreCompInfo preCompInfo = null;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    protected ECPoint(ECCurve curve, ECFieldElement x, ECFieldElement y) {
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean isInfinity() {
        return this.x == null && this.y == null;
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ECPoint)) {
            return false;
        }
        ECPoint o = (ECPoint)other;
        if (this.isInfinity()) {
            return o.isInfinity();
        }
        return this.x.equals(o.x) && this.y.equals(o.y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }

    void setPreCompInfo(PreCompInfo preCompInfo) {
        this.preCompInfo = preCompInfo;
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    synchronized void assertECMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = new FpNafMultiplier();
        }
    }

    public ECPoint multiply(BigInteger k) {
        if (k.signum() < 0) {
            throw new IllegalArgumentException("The multiplicator cannot be negative");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (k.signum() == 0) {
            return this.curve.getInfinity();
        }
        this.assertECMultiplier();
        return this.multiplier.multiply(this, k, this.preCompInfo);
    }

    public static class F2m
    extends ECPoint {
        public F2m(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            this(curve, x, y, false);
        }

        public F2m(ECCurve curve, ECFieldElement x, ECFieldElement y, boolean withCompression) {
            super(curve, x, y);
            if (x != null && y == null || x == null && y != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            if (x != null) {
                ECFieldElement.F2m.checkFieldElements(this.x, this.y);
                if (curve != null) {
                    ECFieldElement.F2m.checkFieldElements(this.x, this.curve.getA());
                }
            }
            this.withCompression = withCompression;
        }

        @Override
        public byte[] getEncoded() {
            byte[] PO;
            if (this.isInfinity()) {
                return new byte[1];
            }
            int byteCount = converter.getByteLength(this.x);
            byte[] X = converter.integerToBytes(this.getX().toBigInteger(), byteCount);
            if (this.withCompression) {
                PO = new byte[byteCount + 1];
                PO[0] = 2;
                if (!this.getX().toBigInteger().equals(ECConstants.ZERO) && this.getY().multiply(this.getX().invert()).toBigInteger().testBit(0)) {
                    PO[0] = 3;
                }
                System.arraycopy(X, 0, PO, 1, byteCount);
            } else {
                byte[] Y = converter.integerToBytes(this.getY().toBigInteger(), byteCount);
                PO = new byte[byteCount + byteCount + 1];
                PO[0] = 4;
                System.arraycopy(X, 0, PO, 1, byteCount);
                System.arraycopy(Y, 0, PO, byteCount + 1, byteCount);
            }
            return PO;
        }

        private static void checkPoints(ECPoint a, ECPoint b) {
            if (!a.curve.equals(b.curve)) {
                throw new IllegalArgumentException("Only points on the same curve can be added or subtracted");
            }
        }

        @Override
        public ECPoint add(ECPoint b) {
            F2m.checkPoints(this, b);
            return this.addSimple((F2m)b);
        }

        public F2m addSimple(F2m b) {
            F2m other = b;
            if (this.isInfinity()) {
                return other;
            }
            if (other.isInfinity()) {
                return this;
            }
            ECFieldElement.F2m x2 = (ECFieldElement.F2m)other.getX();
            ECFieldElement.F2m y2 = (ECFieldElement.F2m)other.getY();
            if (this.x.equals(x2)) {
                if (this.y.equals(y2)) {
                    return (F2m)this.twice();
                }
                return (F2m)this.curve.getInfinity();
            }
            ECFieldElement.F2m lambda = (ECFieldElement.F2m)this.y.add(y2).divide(this.x.add(x2));
            ECFieldElement.F2m x3 = (ECFieldElement.F2m)lambda.square().add(lambda).add(this.x).add(x2).add(this.curve.getA());
            ECFieldElement.F2m y3 = (ECFieldElement.F2m)lambda.multiply(this.x.add(x3)).add(x3).add(this.y);
            return new F2m(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint b) {
            F2m.checkPoints(this, b);
            return this.subtractSimple((F2m)b);
        }

        public F2m subtractSimple(F2m b) {
            if (b.isInfinity()) {
                return this;
            }
            return this.addSimple((F2m)b.negate());
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.x.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement.F2m lambda = (ECFieldElement.F2m)this.x.add(this.y.divide(this.x));
            ECFieldElement.F2m x3 = (ECFieldElement.F2m)lambda.square().add(lambda).add(this.curve.getA());
            ECFieldElement ONE = this.curve.fromBigInteger(ECConstants.ONE);
            ECFieldElement.F2m y3 = (ECFieldElement.F2m)this.x.square().add(x3.multiply(lambda.add(ONE)));
            return new F2m(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint negate() {
            return new F2m(this.curve, this.getX(), this.getY().add(this.getX()), this.withCompression);
        }

        @Override
        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                this.multiplier = ((ECCurve.F2m)this.curve).isKoblitz() ? new WTauNafMultiplier() : new WNafMultiplier();
            }
        }
    }

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            this(curve, x, y, false);
        }

        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y, boolean withCompression) {
            super(curve, x, y);
            if (x != null && y == null || x == null && y != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = withCompression;
        }

        @Override
        public byte[] getEncoded() {
            if (this.isInfinity()) {
                return new byte[1];
            }
            int qLength = converter.getByteLength(this.x);
            if (this.withCompression) {
                int PC = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] X = converter.integerToBytes(this.getX().toBigInteger(), qLength);
                byte[] PO = new byte[X.length + 1];
                PO[0] = PC;
                System.arraycopy(X, 0, PO, 1, X.length);
                return PO;
            }
            byte[] X = converter.integerToBytes(this.getX().toBigInteger(), qLength);
            byte[] Y = converter.integerToBytes(this.getY().toBigInteger(), qLength);
            byte[] PO = new byte[X.length + Y.length + 1];
            PO[0] = 4;
            System.arraycopy(X, 0, PO, 1, X.length);
            System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
            return PO;
        }

        @Override
        public ECPoint add(ECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            if (this.x.equals(b.x)) {
                if (this.y.equals(b.y)) {
                    return this.twice();
                }
                return this.curve.getInfinity();
            }
            ECFieldElement gamma = b.y.subtract(this.y).divide(b.x.subtract(this.x));
            ECFieldElement x3 = gamma.square().subtract(this.x).subtract(b.x);
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.y.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement TWO = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement THREE = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement gamma = this.x.square().multiply(THREE).add(this.curve.a).divide(this.y.multiply(TWO));
            ECFieldElement x3 = gamma.square().subtract(this.x.multiply(TWO));
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint b) {
            if (b.isInfinity()) {
                return this;
            }
            return this.add(b.negate());
        }

        @Override
        public ECPoint negate() {
            return new Fp(this.curve, this.x, this.y.negate(), this.withCompression);
        }

        @Override
        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                this.multiplier = new WNafMultiplier();
            }
        }
    }
}

