/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import com.crashlytics.android.beta.BuildProperties;
import com.crashlytics.android.beta.CheckForUpdatesResponse;
import com.crashlytics.android.beta.CheckForUpdatesResponseTransform;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class CheckForUpdatesRequest
extends AbstractSpiCall {
    static final String BUILD_VERSION = "build_version";
    static final String DISPLAY_VERSION = "display_version";
    static final String INSTANCE = "instance";
    static final String SOURCE = "source";
    static final String BETA_SOURCE = "3";
    private final CheckForUpdatesResponseTransform responseTransform;

    public CheckForUpdatesRequest(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, CheckForUpdatesResponseTransform responseTransform) {
        super(kit, protocolAndHostOverride, url, requestFactory, HttpMethod.GET);
        this.responseTransform = responseTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckForUpdatesResponse invoke(String apiKey, String idHeaderValue, BuildProperties buildProps) {
        HttpRequest httpRequest = null;
        try {
            Map<String, String> queryParams = this.getQueryParamsFor(buildProps);
            httpRequest = this.getHttpRequest(queryParams);
            httpRequest = this.applyHeadersTo(httpRequest, apiKey, idHeaderValue);
            Fabric.getLogger().d("Beta", "Checking for updates from " + this.getUrl());
            Fabric.getLogger().d("Beta", "Checking for updates query params are: " + queryParams);
            if (httpRequest.ok()) {
                Fabric.getLogger().d("Beta", "Checking for updates was successful");
                JSONObject responseJson = new JSONObject(httpRequest.body());
                CheckForUpdatesResponse checkForUpdatesResponse = this.responseTransform.fromJson(responseJson);
                return checkForUpdatesResponse;
            }
            Fabric.getLogger().e("Beta", "Checking for updates failed. Response code: " + httpRequest.code());
        }
        catch (Exception e) {
            Fabric.getLogger().e("Beta", "Error while checking for updates from " + this.getUrl(), (Throwable)e);
        }
        finally {
            if (httpRequest != null) {
                String requestId = httpRequest.header("X-REQUEST-ID");
                Fabric.getLogger().d("Fabric", "Checking for updates request ID: " + requestId);
            }
        }
        return null;
    }

    private HttpRequest applyHeadersTo(HttpRequest request, String apiKey, String idHeaderValue) {
        return request.header("Accept", "application/json").header("User-Agent", "Crashlytics Android SDK/" + this.kit.getVersion()).header("X-CRASHLYTICS-DEVELOPER-TOKEN", "bca6990fc3c15a8105800c0673517a4b579634a1").header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", this.kit.getVersion()).header("X-CRASHLYTICS-API-KEY", apiKey).header("X-CRASHLYTICS-D", idHeaderValue);
    }

    private Map<String, String> getQueryParamsFor(BuildProperties buildProps) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(BUILD_VERSION, buildProps.versionCode);
        queryParams.put(DISPLAY_VERSION, buildProps.versionName);
        queryParams.put(INSTANCE, buildProps.buildId);
        queryParams.put(SOURCE, BETA_SOURCE);
        return queryParams;
    }
}

