/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zzc;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static int zzavP = 5000000;
    public static int zzavQ = 6500000;
    public static int zzavR = 7000000;
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    @Deprecated
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    @Deprecated
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    public static final String INSTANCE_ID_SCOPE = "GCM";
    static GoogleCloudMessaging zzavS;
    private Context zzpH;
    private PendingIntent zzavT;
    private Map<String, Handler> zzavU;
    private static final AtomicInteger zzavV;
    private final BlockingQueue<Intent> zzavW = new LinkedBlockingQueue<Intent>();
    final Messenger zzavX;

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzavS == null) {
            zzavS = new GoogleCloudMessaging();
            GoogleCloudMessaging.zzavS.zzpH = context.getApplicationContext();
        }
        return zzavS;
    }

    public GoogleCloudMessaging() {
        this.zzavU = Collections.synchronizedMap(new HashMap());
        this.zzavX = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Intent intent;
                if (msg == null || !(msg.obj instanceof Intent)) {
                    Log.w((String)GoogleCloudMessaging.INSTANCE_ID_SCOPE, (String)"Dropping invalid message");
                }
                if ("com.google.android.c2dm.intent.REGISTRATION".equals((intent = (Intent)msg.obj).getAction())) {
                    GoogleCloudMessaging.this.zzavW.add(intent);
                } else if (!GoogleCloudMessaging.this.zzl(intent)) {
                    intent.setPackage(GoogleCloudMessaging.this.zzpH.getPackageName());
                    GoogleCloudMessaging.this.zzpH.sendBroadcast(intent);
                }
            }
        });
    }

    public void close() {
        zzavS = null;
        zza.zzavF = null;
        this.zztT();
    }

    public void send(String to, String msgId, Bundle data) throws IOException {
        this.send(to, msgId, -1L, data);
    }

    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        this.zza(to, msgId, timeToLive, -1, data);
    }

    private void zza(String string, String string2, long l, int n, Bundle bundle) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.zzm(intent);
        intent.setPackage(GoogleCloudMessaging.zzas(this.zzpH));
        intent.putExtra("google.to", string);
        intent.putExtra("google.message_id", string2);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(n));
        if (GoogleCloudMessaging.zzas(this.zzpH).contains(".gsf")) {
            Bundle bundle2 = new Bundle();
            for (String string3 : bundle.keySet()) {
                Object object = bundle.get(string3);
                if (!(object instanceof String)) continue;
                bundle2.putString("gcm." + string3, (String)object);
            }
            bundle2.putString("google.to", string);
            bundle2.putString("google.message_id", string2);
            InstanceID.getInstance(this.zzpH).zzc(INSTANCE_ID_SCOPE, "upstream", bundle2);
            return;
        }
        this.zzpH.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private boolean zzl(Intent intent) {
        String string = intent.getStringExtra("In-Reply-To");
        if (string == null && intent.hasExtra("error")) {
            string = intent.getStringExtra("google.message_id");
        }
        Handler handler = null;
        if (string != null && (handler = this.zzavU.remove(string)) != null) {
            Message message = Message.obtain();
            message.obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    private String zztS() {
        return "google.rpc" + String.valueOf(zzavV.getAndIncrement());
    }

    @Deprecated
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        InstanceID.getInstance(this.zzpH).deleteInstanceID();
    }

    @Deprecated
    public synchronized String register(String ... senderIds) throws IOException {
        String string = this.zzc(senderIds);
        Bundle bundle = new Bundle();
        if (GoogleCloudMessaging.zzas(this.zzpH).contains(".gsf")) {
            bundle.putString("legacy.sender", string);
            return InstanceID.getInstance(this.zzpH).getToken(string, INSTANCE_ID_SCOPE, bundle);
        }
        bundle.putString("sender", string);
        Intent intent = this.zzx(bundle);
        return GoogleCloudMessaging.zza(intent, "registration_id");
    }

    @Deprecated
    Intent zzx(Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        int n = GoogleCloudMessaging.zzat(this.zzpH);
        if (n < 0) {
            throw new IOException("Google Play Services missing");
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(GoogleCloudMessaging.zzas(this.zzpH));
        this.zzm(intent);
        String string = this.zztS();
        intent.putExtra("google.message_id", string);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzavX);
        this.zzpH.startService(intent);
        Intent intent2 = null;
        try {
            intent2 = this.zzavW.poll(30000L, TimeUnit.MILLISECONDS);
            return intent2;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    static String zza(Intent intent, String string) throws IOException {
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string2 = intent.getStringExtra(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = intent.getStringExtra("error");
        if (string3 != null) {
            throw new IOException(string3);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    String zzc(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            return null;
        }
        String string2 = intent.getStringExtra("message_type");
        if (string2 != null) {
            return string2;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void zzm(Intent intent) {
        if (this.zzavT == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzavT = PendingIntent.getBroadcast((Context)this.zzpH, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzavT);
    }

    synchronized void zztT() {
        if (this.zzavT != null) {
            this.zzavT.cancel();
            this.zzavT = null;
        }
    }

    public static String zzas(Context context) {
        return zzc.zzaw(context);
    }

    public static int zzat(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(GoogleCloudMessaging.zzas(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static {
        zzavV = new AtomicInteger(1);
    }
}

