/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzIp;
    private final Tracker zzIq;
    private final Context mContext;
    private ExceptionParser zzIr;
    private GoogleAnalytics zzIs;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzIp = originalHandler;
        this.zzIq = tracker;
        this.zzIr = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzae.zzaB("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzIr;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzIr = exceptionParser;
    }

    GoogleAnalytics zzhg() {
        if (this.zzIs == null) {
            this.zzIs = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzIs;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string = "UncaughtException";
        if (this.zzIr != null) {
            object = t != null ? t.getName() : null;
            string = this.zzIr.getDescription((String)object, e);
        }
        zzae.zzaB("Reporting uncaught exception: " + string);
        this.zzIq.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzhg();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzhk();
        if (this.zzIp != null) {
            zzae.zzaB("Passing exception to the original handler");
            this.zzIp.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zzhh() {
        return this.zzIp;
    }
}

