/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzu;

class zzag
extends BroadcastReceiver {
    static final String zzMo = zzag.class.getName();
    private final zzf zzJy;
    private boolean zzMp;
    private boolean zzMq;

    zzag(zzf zzf2) {
        zzu.zzu((Object)zzf2);
        this.zzJy = zzf2;
    }

    public void onReceive(Context ctx, Intent intent) {
        this.zzke();
        String string = intent.getAction();
        this.zzJy.zzhQ().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzkg();
            if (this.zzMq != bl) {
                this.zzMq = bl;
                this.zzhl().zzG(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzMo)) {
                this.zzhl().zzhK();
            }
            return;
        }
        this.zzJy.zzhQ().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzkd() {
        this.zzke();
        if (this.zzMp) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzMq = this.zzkg();
        this.zzJy.zzhQ().zza("Registering connectivity change receiver. Network connected", this.zzMq);
        this.zzMp = true;
    }

    private void zzke() {
        this.zzhQ();
        this.zzhl();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzJy.zzhQ().zzaT("Unregistering connectivity change receiver");
        this.zzMp = false;
        this.zzMq = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzhQ().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzkf() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzMo, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzMp;
    }

    public boolean isConnected() {
        if (!this.zzMp) {
            this.zzJy.zzhQ().zzaW("Connectivity unknown. Receiver not registered");
        }
        return this.zzMq;
    }

    protected boolean zzkg() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzJy.getContext();
    }

    private zzaf zzhQ() {
        return this.zzJy.zzhQ();
    }

    private zzb zzhl() {
        return this.zzJy.zzhl();
    }
}

