/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzny;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj zzKn;
    private final zzah zzKo;
    private final zzag zzKp;
    private final zzi zzKq;
    private long zzKr;
    private final zzt zzKs;
    private final zzt zzKt;
    private final zzaj zzKu;
    private long zzKv;
    private boolean zzKw;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzu.zzu((Object)zzg2);
        this.zzKr = Long.MIN_VALUE;
        this.zzKp = zzg2.zzk(zzf2);
        this.zzKn = zzg2.zzm(zzf2);
        this.zzKo = zzg2.zzn(zzf2);
        this.zzKq = zzg2.zzo(zzf2);
        this.zzKu = new zzaj(this.zzhP());
        this.zzKs = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zziA();
            }
        };
        this.zzKt = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zziB();
            }
        };
    }

    @Override
    protected void zzhn() {
        this.zzKn.zza();
        this.zzKo.zza();
        this.zzKq.zza();
    }

    void start() {
        this.zzia();
        zzu.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        if (!this.zzhR().zziW()) {
            this.zziy();
        }
        this.zzhS().zze(new Runnable(){

            @Override
            public void run() {
                zzl.this.zziz();
            }
        });
    }

    private void zziy() {
        boolean bl;
        zzf zzf2 = this.zzhM();
        Context context = zzf2.getContext();
        boolean bl2 = AnalyticsReceiver.zzT(context);
        if (!bl2) {
            this.zzaW("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = AnalyticsService.zzU(context);
            if (!bl) {
                this.zzaX("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzT(context);
        if (!bl) {
            this.zzaW("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzU(context);
            if (!bl3) {
                this.zzaW("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzba(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zziz() {
        this.zzia();
        this.zzhU().zzkk();
        if (!this.zzba("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzaX("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zziO();
        }
        if (!this.zzba("android.permission.INTERNET")) {
            this.zzaX("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zziO();
        }
        if (AnalyticsService.zzU(this.getContext())) {
            this.zzaT("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zzhR().zziW()) {
            this.zzaX("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzaW("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzKw || this.zzhR().zziW() || this.zzKn.isEmpty())) {
            this.zziC();
        }
        this.zziG();
    }

    private void zziA() {
        this.zzb(new zzw(){

            @Override
            public void zzc(Throwable throwable) {
                zzl.this.zziG();
            }
        });
    }

    void zzhL() {
        this.zzhO();
        this.zzKv = this.zzhP().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzhO();
        if (!this.zzhR().zziW()) {
            this.zziD();
        }
    }

    public void zzhJ() {
        zzns.zzhO();
        this.zzia();
        this.zzaT("Service disconnected");
    }

    public void zzG(boolean bl) {
        this.zziG();
    }

    private void zziB() {
        try {
            this.zzKn.zzis();
            this.zziG();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzKt.zzt(this.zzhR().zzjy());
    }

    protected void zzc(zzh zzh2) {
        this.zzhO();
        this.zzb("Sending first hit to property", zzh2.zzij());
        if (this.zzhU().zzkl().zzv(this.zzhR().zzjB())) {
            return;
        }
        String string = this.zzhU().zzko();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzny zzny2 = zzam.zza(this.zzhQ(), string);
        this.zzb("Found relevant installation campaign", zzny2);
        this.zza(zzh2, zzny2);
    }

    public void zzs(long l) {
        zzns.zzhO();
        this.zzia();
        if (l < 0L) {
            l = 0L;
        }
        this.zzKr = l;
        this.zziG();
    }

    protected void zziC() {
        if (this.zzKw) {
            return;
        }
        if (!this.zzhR().zziY()) {
            return;
        }
        if (this.zzKq.isConnected()) {
            return;
        }
        long l = this.zzhR().zzjt();
        if (this.zzKu.zzv(l)) {
            this.zzKu.start();
            this.zzaT("Connecting to service");
            if (this.zzKq.connect()) {
                this.zzaT("Connected to service");
                this.zzKu.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzu.zzu((Object)zzh2);
        this.zzia();
        this.zzhO();
        long l = -1L;
        try {
            this.zzKn.beginTransaction();
            this.zzKn.zza(zzh2.zzii(), zzh2.getClientId());
            l = this.zzKn.zza(zzh2.zzii(), zzh2.getClientId(), zzh2.zzij());
            if (!bl) {
                zzh2.zzn(l);
            } else {
                zzh2.zzn(l + 1L);
            }
            this.zzKn.zzb(zzh2);
            this.zzKn.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return l2;
        }
        finally {
            try {
                this.zzKn.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzab zzab2) {
        zzu.zzu((Object)zzab2);
        zzns.zzhO();
        this.zzia();
        if (this.zzKw) {
            this.zzaU("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zziC();
        if (this.zzKq.zzb(zzab2)) {
            this.zzaU("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zzhR().zziW()) {
            this.zzhQ().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzKn.zzc(zzab2);
            this.zziG();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzhQ().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zzhG() {
        zzns.zzhO();
        this.zzia();
        if (!this.zzhR().zziW()) {
            this.zzaT("Delete all hits from local store");
            try {
                this.zzKn.zziq();
                this.zzKn.zzir();
                this.zziG();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zziC();
        if (this.zzKq.zzim()) {
            this.zzaT("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zzka())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zzhU().zzkp();
        Pair<String, Long> pair = zza2.zzks();
        if (pair == null) {
            return zzab2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        String string2 = l + ":" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>(zzab2.zzn());
        hashMap.put("_m", string2);
        return zzab.zza(this, zzab2, hashMap);
    }

    public void zziD() {
        zzns.zzhO();
        this.zzia();
        this.zzhN();
        if (!this.zzhR().zziY()) {
            this.zzaW("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzKq.isConnected()) {
            this.zzaT("Service not connected");
            return;
        }
        if (this.zzKn.isEmpty()) {
            return;
        }
        this.zzaT("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.zzKn.zzp(this.zzhR().zzjh());
                if (list.isEmpty()) {
                    this.zziG();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zziK();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.zzKq.zzb(zzab2)) {
                    this.zziG();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.zzKn.zzq(zzab2.zzjV());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zziK();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zziE() {
        boolean bl;
        zzns.zzhO();
        this.zzia();
        this.zzaT("Dispatching a batch of local hits");
        boolean bl2 = !this.zzKq.isConnected() && !this.zzhR().zziW();
        boolean bl3 = bl = !this.zzKo.zzkg();
        if (bl2 && bl) {
            this.zzaT("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzhR().zzjh(), this.zzhR().zzji());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.zzKn.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzKn.zzp(l);
                        if (!list.isEmpty()) break block38;
                        this.zzaT("Store is empty, nothing to dispatch");
                        this.zziK();
                        boolean bl4 = false;
                        return bl4;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zziK();
                        boolean bl5 = false;
                        try {
                            this.zzKn.setTransactionSuccessful();
                            this.zzKn.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zziK();
                            return false;
                        }
                        return bl5;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zzjV() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zziK();
                    boolean bl6 = false;
                    return bl6;
                }
                if (this.zzKq.isConnected() && !this.zzhR().zziW()) {
                    this.zzaT("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzKq.zzb((zzab)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzab)object2).zzjV());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzKn.zzq(((zzab)object2).zzjV());
                            arrayList.add(((zzab)object2).zzjV());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zziK();
                            boolean bl7 = false;
                            try {
                                this.zzKn.setTransactionSuccessful();
                                this.zzKn.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zziK();
                                return false;
                            }
                            return bl7;
                        }
                    }
                }
                if (this.zzKo.zzkg()) {
                    object2 = this.zzKo.zzf(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    list.removeAll((Collection<?>)object2);
                    try {
                        this.zzKn.zzd((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zziK();
                        boolean bl8 = false;
                        try {
                            this.zzKn.setTransactionSuccessful();
                            this.zzKn.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zziK();
                            return false;
                        }
                        return bl8;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return bl9;
            }
            finally {
                try {
                    this.zzKn.setTransactionSuccessful();
                    this.zzKn.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zziK();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.zzKv);
    }

    public void zza(final zzw zzw2, final long l) {
        block8: {
            zzns.zzhO();
            this.zzia();
            long l2 = -1L;
            long l3 = this.zzhU().zzkm();
            if (l3 != 0L) {
                l2 = Math.abs(this.zzhP().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zzhR().zziW()) {
                this.zziC();
            }
            try {
                boolean bl = this.zziE();
                if (bl) {
                    this.zzhS().zze(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l);
                        }
                    });
                } else {
                    this.zzhU().zzkn();
                    this.zziG();
                    if (zzw2 != null) {
                        zzw2.zzc(null);
                    }
                    if (this.zzKv != l) {
                        this.zzKp.zzkf();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zzhU().zzkn();
                this.zziG();
                if (zzw2 == null) break block8;
                zzw2.zzc(throwable);
            }
        }
    }

    public void zziF() {
        zzns.zzhO();
        this.zzia();
        this.zzaU("Sync dispatching local hits");
        long l = this.zzKv;
        if (!this.zzhR().zziW()) {
            this.zziC();
        }
        try {
            while (this.zziE()) {
            }
            this.zzhU().zzkn();
            this.zziG();
            if (this.zzKv != l) {
                this.zzKp.zzkf();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zziG();
        }
    }

    public long zzit() {
        zzns.zzhO();
        this.zzia();
        try {
            return this.zzKn.zzit();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zziG() {
        boolean bl;
        this.zzhM().zzhO();
        this.zzia();
        if (!this.zziH()) {
            this.zzKp.unregister();
            this.zziK();
            return;
        }
        if (this.zzKn.isEmpty()) {
            this.zzKp.unregister();
            this.zziK();
            return;
        }
        if (!zzy.zzLI.get().booleanValue()) {
            this.zzKp.zzkd();
            bl = this.zzKp.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zziJ();
        } else {
            this.zziK();
            this.zziI();
        }
    }

    private boolean zziH() {
        if (this.zzKw) {
            return false;
        }
        if (this.zzhR().zziW() && !this.zzhR().zziX()) {
            return false;
        }
        return this.zziN() > 0L;
    }

    private void zziI() {
        long l;
        long l2;
        long l3;
        zzv zzv2 = this.zzhT();
        if (!zzv2.zzjG()) {
            return;
        }
        if (!zzv2.zzbp() && (l3 = this.zzit()) != 0L && (l2 = Math.abs((l = this.zzhP().currentTimeMillis()) - l3)) <= this.zzhR().zzjg()) {
            long l4 = this.zzhR().zzjf();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzv2.zzjH();
        }
    }

    private void zziJ() {
        long l;
        long l2;
        this.zziI();
        long l3 = this.zziN();
        long l4 = this.zzhU().zzkm();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zzhP().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzhR().zzjd(), l3)) : Math.min(this.zzhR().zzjd(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzKs.zzbp()) {
            l = Math.max(1L, l5 + this.zzKs.zzjD());
            this.zzKs.zzu(l);
        } else {
            this.zzKs.zzt(l5);
        }
    }

    private void zziK() {
        this.zziL();
        this.zziM();
    }

    private void zziL() {
        if (this.zzKs.zzbp()) {
            this.zzaT("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzKs.cancel();
    }

    private void zziM() {
        zzv zzv2 = this.zzhT();
        if (zzv2.zzbp()) {
            zzv2.cancel();
        }
    }

    public long zziN() {
        if (this.zzKr != Long.MIN_VALUE) {
            return this.zzKr;
        }
        long l = this.zzhR().zzje();
        if (this.zzhm().zzjQ()) {
            l = (long)this.zzhm().zzkH() * 1000L;
        }
        return l;
    }

    public void zzbb(String string) {
        zzu.zzcj((String)string);
        this.zzhO();
        this.zzhN();
        zzny zzny2 = zzam.zza(this.zzhQ(), string);
        if (zzny2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzhU().zzko();
        if (string.equals(string2)) {
            this.zzaW("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzhU().zzbf(string);
        if (this.zzhU().zzkl().zzv(this.zzhR().zzjB())) {
            this.zzd("Campaign received too late, ignoring", zzny2);
            return;
        }
        this.zzb("Received installation campaign", zzny2);
        List<zzh> list = this.zzKn.zzr(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzny2);
        }
    }

    private void zza(zzh zzh2, zzny zzny2) {
        zzu.zzu((Object)zzh2);
        zzu.zzu((Object)zzny2);
        zza zza2 = new zza(this.zzhM());
        zza2.zzaI(zzh2.zzij());
        zza2.enableAdvertisingIdCollection(zzh2.zzik());
        zzno zzno2 = zza2.zzhc();
        zzip zzip2 = zzno2.zze(zzip.class);
        zzip2.zzaN("data");
        zzip2.zzF(true);
        zzno2.zzb(zzny2);
        zzio zzio2 = zzno2.zze(zzio.class);
        zznx zznx2 = zzno2.zze(zznx.class);
        for (Map.Entry<String, String> entry : zzh2.zzn().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zznx2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zznx2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zznx2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zznx2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzip2.setUserId(string2);
                continue;
            }
            zzio2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzh2.zzij(), zzny2);
        zzno2.zzL(this.zzhU().zzkk());
        zzno2.zzvT();
    }

    public void zziO() {
        this.zzia();
        this.zzhO();
        this.zzKw = true;
        this.zzKq.disconnect();
        this.zziG();
    }
}

