/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzod;
import java.util.HashMap;
import java.util.Map;

public final class zzog
implements Application.ActivityLifecycleCallbacks {
    private final zznw zzaEV;
    private final Map<Activity, zzod> zzaEW;

    public zzog(zznw zznw2) {
        zzu.zzu((Object)zznw2);
        this.zzaEV = zznw2;
        this.zzaEW = new HashMap<Activity, zzod>();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        Bundle bundle = savedInstanceState.getBundle("com.google.android.gms.measurement.screen_view");
        if (bundle == null) {
            return;
        }
        int n = bundle.getInt("id");
        if (n <= 0) {
            Log.w((String)"com.google.android.gms.measurement.internal.ActivityLifecycleTracker", (String)"Invalid screenId in saved activity state");
            return;
        }
        zzod zzod2 = this.zza(activity, n);
        zzod2.setScreenName(bundle.getString("name"));
        zzod2.zzhL(bundle.getInt("referrer_id"));
        zzod2.zzdJ(bundle.getString("referrer_name"));
        zzod2.zzai(bundle.getBoolean("interstitial"));
        zzod2.zzwF();
    }

    public void onActivityStarted(Activity activity) {
        zzod zzod2 = this.zza(activity, 0);
        this.zzaEV.zzb(zzod2, activity);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (outState == null) {
            return;
        }
        zzod zzod2 = this.zzaEW.get(activity);
        if (zzod2 == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("id", zzod2.zzbn());
        bundle.putString("name", zzod2.zzwB());
        bundle.putInt("referrer_id", zzod2.zzwC());
        bundle.putString("referrer_name", zzod2.zzwD());
        bundle.putBoolean("interstitial", zzod2.zzwG());
        outState.putBundle("com.google.android.gms.measurement.screen_view", bundle);
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzaEW.remove(activity);
    }

    zzod zza(Activity activity, int n) {
        zzu.zzu((Object)activity);
        zzod zzod2 = this.zzaEW.get(activity);
        if (zzod2 == null) {
            zzod2 = n == 0 ? new zzod(true) : new zzod(true, n);
            zzod2.setScreenName(activity.getClass().getCanonicalName());
            this.zzaEW.put(activity, zzod2);
        }
        return zzod2;
    }
}

