/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcn
implements zzp.zzf {
    private final Context mContext;
    private final String zzaKy;
    private final ExecutorService zzaNb;
    private zzbf<zzpx.zza> zzaMU;

    zzcn(Context context, String string) {
        this.mContext = context;
        this.zzaKy = string;
        this.zzaNb = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbf<zzpx.zza> zzbf2) {
        this.zzaMU = zzbf2;
    }

    @Override
    public void zzyw() {
        this.zzaNb.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzzn();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzzn() {
        if (this.zzaMU == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzaMU.zzyv();
        zzbg.zzaB("Attempting to load resource from disk");
        if ((zzcb.zzzf().zzzg() == zzcb.zza.zzaMJ || zzcb.zzzf().zzzg() == zzcb.zza.zzaMK) && this.zzaKy.equals(zzcb.zzzf().getContainerId())) {
            this.zzaMU.zza(zzbf.zza.zzaMi);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzzo());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzay("Failed to find the resource in the disk");
            this.zzaMU.zza(zzbf.zza.zzaMi);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzqf.zzc(fileInputStream, byteArrayOutputStream);
            zzpx.zza zza2 = zzpx.zza.zzs(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzaMU.zzz(zza2);
        }
        catch (IOException iOException) {
            this.zzaMU.zza(zzbf.zza.zzaMj);
            zzbg.zzaC("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzaMU.zza(zzbf.zza.zzaMj);
            zzbg.zzaC("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaC("Error closing stream for reading resource from disk");
            }
        }
        zzbg.zzaB("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzpx.zza zza2) {
        this.zzaNb.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzqf.zzc zziR(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzaC("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbg.zzaB("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzqf.zzc(inputStream, byteArrayOutputStream);
            zzqf.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbg.zzaB("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzr(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbg.zzaC("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzqf.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzaz.zzey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbg.zzay("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbg.zzaC("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzqf.zzc zzr(byte[] byArray) {
        try {
            zzqf.zzc zzc2 = zzqf.zzb(zzaf.zzf.zzc(byArray));
            if (zzc2 != null) {
                zzbg.zzaB("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzrm zzrm2) {
            zzbg.zzaz("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzqf.zzg zzg2) {
            zzbg.zzaC("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzaNb.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzpx.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzzo();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaz("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzrn.zzf((zzrn)zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbg.zzaC("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaC("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzzo() {
        String string = "resource_" + this.zzaKy;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void zzd(zzpx.zza zza2) throws IllegalArgumentException {
        if (zza2.zziO == null && zza2.zzaPa == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

