/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.IntentCompatHoneycomb;

public class IntentCompat {
    private static final IntentCompatImpl IMPL;

    public static Intent makeMainActivity(ComponentName mainActivity) {
        return IMPL.makeMainActivity(mainActivity);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 15 ? new IntentCompatImplIcsMr1() : (version >= 11 ? new IntentCompatImplHC() : new IntentCompatImplBase());
    }

    static class IntentCompatImplIcsMr1
    extends IntentCompatImplHC {
        IntentCompatImplIcsMr1() {
        }
    }

    static class IntentCompatImplHC
    extends IntentCompatImplBase {
        IntentCompatImplHC() {
        }

        @Override
        public Intent makeMainActivity(ComponentName componentName) {
            return IntentCompatHoneycomb.makeMainActivity(componentName);
        }
    }

    static class IntentCompatImplBase
    implements IntentCompatImpl {
        IntentCompatImplBase() {
        }

        @Override
        public Intent makeMainActivity(ComponentName componentName) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setComponent(componentName);
            intent.addCategory("android.intent.category.LAUNCHER");
            return intent;
        }
    }

    static interface IntentCompatImpl {
        public Intent makeMainActivity(ComponentName var1);
    }
}

