/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.graphics.drawable.DrawableCompatApi22;
import android.support.v4.graphics.drawable.DrawableCompatBase;
import android.support.v4.graphics.drawable.DrawableCompatHoneycomb;
import android.support.v4.graphics.drawable.DrawableCompatKitKat;
import android.support.v4.graphics.drawable.DrawableCompatLollipop;
import android.support.v4.graphics.drawable.DrawableWrapper;

public class DrawableCompat {
    static final DrawableImpl IMPL;

    public static void jumpToCurrentState(Drawable drawable2) {
        IMPL.jumpToCurrentState(drawable2);
    }

    public static void setAutoMirrored(Drawable drawable2, boolean mirrored) {
        IMPL.setAutoMirrored(drawable2, mirrored);
    }

    public static boolean isAutoMirrored(Drawable drawable2) {
        return IMPL.isAutoMirrored(drawable2);
    }

    public static void setHotspot(Drawable drawable2, float x, float y) {
        IMPL.setHotspot(drawable2, x, y);
    }

    public static void setHotspotBounds(Drawable drawable2, int left, int top, int right, int bottom) {
        IMPL.setHotspotBounds(drawable2, left, top, right, bottom);
    }

    public static void setTint(Drawable drawable2, int tint) {
        IMPL.setTint(drawable2, tint);
    }

    public static void setTintList(Drawable drawable2, ColorStateList tint) {
        IMPL.setTintList(drawable2, tint);
    }

    public static void setTintMode(Drawable drawable2, PorterDuff.Mode tintMode) {
        IMPL.setTintMode(drawable2, tintMode);
    }

    public static Drawable wrap(Drawable drawable2) {
        return IMPL.wrap(drawable2);
    }

    public static <T extends Drawable> T unwrap(Drawable drawable2) {
        if (drawable2 instanceof DrawableWrapper) {
            return (T)((DrawableWrapper)drawable2).getWrappedDrawable();
        }
        return (T)drawable2;
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 22 ? new LollipopMr1DrawableImpl() : (version >= 21 ? new LollipopDrawableImpl() : (version >= 19 ? new KitKatDrawableImpl() : (version >= 11 ? new HoneycombDrawableImpl() : new BaseDrawableImpl())));
    }

    static class LollipopMr1DrawableImpl
    extends LollipopDrawableImpl {
        LollipopMr1DrawableImpl() {
        }

        @Override
        public Drawable wrap(Drawable drawable2) {
            return DrawableCompatApi22.wrapForTinting(drawable2);
        }
    }

    static class LollipopDrawableImpl
    extends KitKatDrawableImpl {
        LollipopDrawableImpl() {
        }

        @Override
        public void setHotspot(Drawable drawable2, float x, float y) {
            DrawableCompatLollipop.setHotspot(drawable2, x, y);
        }

        @Override
        public void setHotspotBounds(Drawable drawable2, int left, int top, int right, int bottom) {
            DrawableCompatLollipop.setHotspotBounds(drawable2, left, top, right, bottom);
        }

        @Override
        public void setTint(Drawable drawable2, int tint) {
            DrawableCompatLollipop.setTint(drawable2, tint);
        }

        @Override
        public void setTintList(Drawable drawable2, ColorStateList tint) {
            DrawableCompatLollipop.setTintList(drawable2, tint);
        }

        @Override
        public void setTintMode(Drawable drawable2, PorterDuff.Mode tintMode) {
            DrawableCompatLollipop.setTintMode(drawable2, tintMode);
        }

        @Override
        public Drawable wrap(Drawable drawable2) {
            return DrawableCompatLollipop.wrapForTinting(drawable2);
        }
    }

    static class KitKatDrawableImpl
    extends HoneycombDrawableImpl {
        KitKatDrawableImpl() {
        }

        @Override
        public void setAutoMirrored(Drawable drawable2, boolean mirrored) {
            DrawableCompatKitKat.setAutoMirrored(drawable2, mirrored);
        }

        @Override
        public boolean isAutoMirrored(Drawable drawable2) {
            return DrawableCompatKitKat.isAutoMirrored(drawable2);
        }

        @Override
        public Drawable wrap(Drawable drawable2) {
            return DrawableCompatKitKat.wrapForTinting(drawable2);
        }
    }

    static class HoneycombDrawableImpl
    extends BaseDrawableImpl {
        HoneycombDrawableImpl() {
        }

        @Override
        public void jumpToCurrentState(Drawable drawable2) {
            DrawableCompatHoneycomb.jumpToCurrentState(drawable2);
        }

        @Override
        public Drawable wrap(Drawable drawable2) {
            return DrawableCompatHoneycomb.wrapForTinting(drawable2);
        }
    }

    static class BaseDrawableImpl
    implements DrawableImpl {
        BaseDrawableImpl() {
        }

        @Override
        public void jumpToCurrentState(Drawable drawable2) {
        }

        @Override
        public void setAutoMirrored(Drawable drawable2, boolean mirrored) {
        }

        @Override
        public boolean isAutoMirrored(Drawable drawable2) {
            return false;
        }

        @Override
        public void setHotspot(Drawable drawable2, float x, float y) {
        }

        @Override
        public void setHotspotBounds(Drawable drawable2, int left, int top, int right, int bottom) {
        }

        @Override
        public void setTint(Drawable drawable2, int tint) {
            DrawableCompatBase.setTint(drawable2, tint);
        }

        @Override
        public void setTintList(Drawable drawable2, ColorStateList tint) {
            DrawableCompatBase.setTintList(drawable2, tint);
        }

        @Override
        public void setTintMode(Drawable drawable2, PorterDuff.Mode tintMode) {
            DrawableCompatBase.setTintMode(drawable2, tintMode);
        }

        @Override
        public Drawable wrap(Drawable drawable2) {
            return DrawableCompatBase.wrapForTinting(drawable2);
        }
    }

    static interface DrawableImpl {
        public void jumpToCurrentState(Drawable var1);

        public void setAutoMirrored(Drawable var1, boolean var2);

        public boolean isAutoMirrored(Drawable var1);

        public void setHotspot(Drawable var1, float var2, float var3);

        public void setHotspotBounds(Drawable var1, int var2, int var3, int var4, int var5);

        public void setTint(Drawable var1, int var2);

        public void setTintList(Drawable var1, ColorStateList var2);

        public void setTintMode(Drawable var1, PorterDuff.Mode var2);

        public Drawable wrap(Drawable var1);
    }
}

