/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.GravityCompatJellybeanMr1;

public class GravityCompat {
    static final GravityCompatImpl IMPL;

    public static int getAbsoluteGravity(int gravity, int layoutDirection) {
        return IMPL.getAbsoluteGravity(gravity, layoutDirection);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 17 ? new GravityCompatImplJellybeanMr1() : new GravityCompatImplBase();
    }

    static class GravityCompatImplJellybeanMr1
    implements GravityCompatImpl {
        GravityCompatImplJellybeanMr1() {
        }

        @Override
        public int getAbsoluteGravity(int gravity, int layoutDirection) {
            return GravityCompatJellybeanMr1.getAbsoluteGravity(gravity, layoutDirection);
        }
    }

    static class GravityCompatImplBase
    implements GravityCompatImpl {
        GravityCompatImplBase() {
        }

        @Override
        public int getAbsoluteGravity(int gravity, int layoutDirection) {
            return gravity & 0xFF7FFFFF;
        }
    }

    static interface GravityCompatImpl {
        public int getAbsoluteGravity(int var1, int var2);
    }
}

