/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompatHoneycomb;
import android.support.v4.view.MenuItemCompatIcs;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;

public class MenuItemCompat {
    static final MenuVersionImpl IMPL;

    public static void setShowAsAction(MenuItem item, int actionEnum) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setShowAsAction(actionEnum);
        } else {
            IMPL.setShowAsAction(item, actionEnum);
        }
    }

    public static MenuItem setActionView(MenuItem item, View view) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setActionView(view);
        }
        return IMPL.setActionView(item, view);
    }

    public static MenuItem setActionView(MenuItem item, int resId) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setActionView(resId);
        }
        return IMPL.setActionView(item, resId);
    }

    public static View getActionView(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getActionView();
        }
        return IMPL.getActionView(item);
    }

    public static MenuItem setActionProvider(MenuItem item, ActionProvider provider) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setSupportActionProvider(provider);
        }
        Log.w((String)"MenuItemCompat", (String)"setActionProvider: item does not implement SupportMenuItem; ignoring");
        return item;
    }

    public static ActionProvider getActionProvider(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getSupportActionProvider();
        }
        Log.w((String)"MenuItemCompat", (String)"getActionProvider: item does not implement SupportMenuItem; returning null");
        return null;
    }

    public static boolean expandActionView(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).expandActionView();
        }
        return IMPL.expandActionView(item);
    }

    public static boolean isActionViewExpanded(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).isActionViewExpanded();
        }
        return IMPL.isActionViewExpanded(item);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 14 ? new IcsMenuVersionImpl() : (version >= 11 ? new HoneycombMenuVersionImpl() : new BaseMenuVersionImpl());
    }

    static class IcsMenuVersionImpl
    extends HoneycombMenuVersionImpl {
        IcsMenuVersionImpl() {
        }

        @Override
        public boolean expandActionView(MenuItem item) {
            return MenuItemCompatIcs.expandActionView(item);
        }

        @Override
        public boolean isActionViewExpanded(MenuItem item) {
            return MenuItemCompatIcs.isActionViewExpanded(item);
        }
    }

    static class HoneycombMenuVersionImpl
    implements MenuVersionImpl {
        HoneycombMenuVersionImpl() {
        }

        @Override
        public void setShowAsAction(MenuItem item, int actionEnum) {
            MenuItemCompatHoneycomb.setShowAsAction(item, actionEnum);
        }

        @Override
        public MenuItem setActionView(MenuItem item, View view) {
            return MenuItemCompatHoneycomb.setActionView(item, view);
        }

        @Override
        public MenuItem setActionView(MenuItem item, int resId) {
            return MenuItemCompatHoneycomb.setActionView(item, resId);
        }

        @Override
        public View getActionView(MenuItem item) {
            return MenuItemCompatHoneycomb.getActionView(item);
        }

        @Override
        public boolean expandActionView(MenuItem item) {
            return false;
        }

        @Override
        public boolean isActionViewExpanded(MenuItem item) {
            return false;
        }
    }

    static class BaseMenuVersionImpl
    implements MenuVersionImpl {
        BaseMenuVersionImpl() {
        }

        @Override
        public void setShowAsAction(MenuItem item, int actionEnum) {
        }

        @Override
        public MenuItem setActionView(MenuItem item, View view) {
            return item;
        }

        @Override
        public MenuItem setActionView(MenuItem item, int resId) {
            return item;
        }

        @Override
        public View getActionView(MenuItem item) {
            return null;
        }

        @Override
        public boolean expandActionView(MenuItem item) {
            return false;
        }

        @Override
        public boolean isActionViewExpanded(MenuItem item) {
            return false;
        }
    }

    public static interface OnActionExpandListener {
        public boolean onMenuItemActionExpand(MenuItem var1);

        public boolean onMenuItemActionCollapse(MenuItem var1);
    }

    static interface MenuVersionImpl {
        public void setShowAsAction(MenuItem var1, int var2);

        public MenuItem setActionView(MenuItem var1, View var2);

        public MenuItem setActionView(MenuItem var1, int var2);

        public View getActionView(MenuItem var1);

        public boolean expandActionView(MenuItem var1);

        public boolean isActionViewExpanded(MenuItem var1);
    }
}

