/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.os.Build;
import android.support.v4.widget.ScrollerCompatGingerbread;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class ScrollerCompat {
    Object mScroller;
    ScrollerCompatImpl mImpl;

    public static ScrollerCompat create(Context context) {
        return ScrollerCompat.create(context, null);
    }

    public static ScrollerCompat create(Context context, Interpolator interpolator) {
        return new ScrollerCompat(context, interpolator);
    }

    ScrollerCompat(Context context, Interpolator interpolator) {
        this(Build.VERSION.SDK_INT, context, interpolator);
    }

    private ScrollerCompat(int apiVersion, Context context, Interpolator interpolator) {
        this.mImpl = apiVersion >= 14 ? new ScrollerCompatImplIcs() : (apiVersion >= 9 ? new ScrollerCompatImplGingerbread() : new ScrollerCompatImplBase());
        this.mScroller = this.mImpl.createScroller(context, interpolator);
    }

    public int getCurrX() {
        return this.mImpl.getCurrX(this.mScroller);
    }

    public int getCurrY() {
        return this.mImpl.getCurrY(this.mScroller);
    }

    public int getFinalX() {
        return this.mImpl.getFinalX(this.mScroller);
    }

    public int getFinalY() {
        return this.mImpl.getFinalY(this.mScroller);
    }

    public boolean computeScrollOffset() {
        return this.mImpl.computeScrollOffset(this.mScroller);
    }

    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mImpl.startScroll(this.mScroller, startX, startY, dx, dy, duration);
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        this.mImpl.fling(this.mScroller, startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
    }

    public void abortAnimation() {
        this.mImpl.abortAnimation(this.mScroller);
    }

    static class ScrollerCompatImplIcs
    extends ScrollerCompatImplGingerbread {
        ScrollerCompatImplIcs() {
        }
    }

    static class ScrollerCompatImplGingerbread
    implements ScrollerCompatImpl {
        ScrollerCompatImplGingerbread() {
        }

        @Override
        public Object createScroller(Context context, Interpolator interpolator) {
            return ScrollerCompatGingerbread.createScroller(context, interpolator);
        }

        @Override
        public int getCurrX(Object scroller) {
            return ScrollerCompatGingerbread.getCurrX(scroller);
        }

        @Override
        public int getCurrY(Object scroller) {
            return ScrollerCompatGingerbread.getCurrY(scroller);
        }

        @Override
        public boolean computeScrollOffset(Object scroller) {
            return ScrollerCompatGingerbread.computeScrollOffset(scroller);
        }

        @Override
        public void startScroll(Object scroller, int startX, int startY, int dx, int dy, int duration) {
            ScrollerCompatGingerbread.startScroll(scroller, startX, startY, dx, dy, duration);
        }

        @Override
        public void fling(Object scroller, int startX, int startY, int velX, int velY, int minX, int maxX, int minY, int maxY) {
            ScrollerCompatGingerbread.fling(scroller, startX, startY, velX, velY, minX, maxX, minY, maxY);
        }

        @Override
        public void abortAnimation(Object scroller) {
            ScrollerCompatGingerbread.abortAnimation(scroller);
        }

        @Override
        public int getFinalX(Object scroller) {
            return ScrollerCompatGingerbread.getFinalX(scroller);
        }

        @Override
        public int getFinalY(Object scroller) {
            return ScrollerCompatGingerbread.getFinalY(scroller);
        }
    }

    static class ScrollerCompatImplBase
    implements ScrollerCompatImpl {
        ScrollerCompatImplBase() {
        }

        @Override
        public Object createScroller(Context context, Interpolator interpolator) {
            return interpolator != null ? new Scroller(context, interpolator) : new Scroller(context);
        }

        @Override
        public int getCurrX(Object scroller) {
            return ((Scroller)scroller).getCurrX();
        }

        @Override
        public int getCurrY(Object scroller) {
            return ((Scroller)scroller).getCurrY();
        }

        @Override
        public boolean computeScrollOffset(Object scroller) {
            Scroller s = (Scroller)scroller;
            return s.computeScrollOffset();
        }

        @Override
        public void startScroll(Object scroller, int startX, int startY, int dx, int dy, int duration) {
            ((Scroller)scroller).startScroll(startX, startY, dx, dy, duration);
        }

        @Override
        public void fling(Object scroller, int startX, int startY, int velX, int velY, int minX, int maxX, int minY, int maxY) {
            ((Scroller)scroller).fling(startX, startY, velX, velY, minX, maxX, minY, maxY);
        }

        @Override
        public void abortAnimation(Object scroller) {
            ((Scroller)scroller).abortAnimation();
        }

        @Override
        public int getFinalX(Object scroller) {
            return ((Scroller)scroller).getFinalX();
        }

        @Override
        public int getFinalY(Object scroller) {
            return ((Scroller)scroller).getFinalY();
        }
    }

    static interface ScrollerCompatImpl {
        public Object createScroller(Context var1, Interpolator var2);

        public int getCurrX(Object var1);

        public int getCurrY(Object var1);

        public boolean computeScrollOffset(Object var1);

        public void startScroll(Object var1, int var2, int var3, int var4, int var5, int var6);

        public void fling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void abortAnimation(Object var1);

        public int getFinalX(Object var1);

        public int getFinalY(Object var1);
    }
}

