/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.util.ArrayMap;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.ContextThemeWrapper;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.AppCompatCheckedTextView;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatMultiAutoCompleteTextView;
import android.support.v7.widget.AppCompatRadioButton;
import android.support.v7.widget.AppCompatRatingBar;
import android.support.v7.widget.AppCompatSpinner;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.View;
import java.lang.reflect.Constructor;
import java.util.Map;

public class AppCompatViewInflater {
    static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final Map<String, Constructor<? extends View>> sConstructorMap = new ArrayMap<String, Constructor<? extends View>>();
    private final Object[] mConstructorArgs = new Object[2];

    public final View createView(View parent, String name, Context context, AttributeSet attrs, boolean inheritContext, boolean readAndroidTheme, boolean readAppTheme) {
        Context originalContext = context;
        if (inheritContext && parent != null) {
            context = parent.getContext();
        }
        if (readAndroidTheme || readAppTheme) {
            context = AppCompatViewInflater.themifyContext(context, attrs, readAndroidTheme, readAppTheme);
        }
        switch (name) {
            case "EditText": {
                return new AppCompatEditText(context, attrs);
            }
            case "Spinner": {
                return new AppCompatSpinner(context, attrs);
            }
            case "CheckBox": {
                return new AppCompatCheckBox(context, attrs);
            }
            case "RadioButton": {
                return new AppCompatRadioButton(context, attrs);
            }
            case "CheckedTextView": {
                return new AppCompatCheckedTextView(context, attrs);
            }
            case "AutoCompleteTextView": {
                return new AppCompatAutoCompleteTextView(context, attrs);
            }
            case "MultiAutoCompleteTextView": {
                return new AppCompatMultiAutoCompleteTextView(context, attrs);
            }
            case "RatingBar": {
                return new AppCompatRatingBar(context, attrs);
            }
            case "Button": {
                return new AppCompatButton(context, attrs);
            }
            case "TextView": {
                return new AppCompatTextView(context, attrs);
            }
        }
        if (originalContext != context) {
            return this.createViewFromTag(context, name, attrs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View createViewFromTag(Context context, String name, AttributeSet attrs) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            this.mConstructorArgs[0] = context;
            this.mConstructorArgs[1] = attrs;
            if (-1 == name.indexOf(46)) {
                View view = this.createView(context, name, "android.widget.");
                return view;
            }
            View view = this.createView(context, name, null);
            return view;
        }
        catch (Exception e) {
            View view = null;
            return view;
        }
        finally {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
        }
    }

    private View createView(Context context, String name, String prefix) throws ClassNotFoundException, InflateException {
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                Class<View> clazz = context.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                constructor = clazz.getConstructor(sConstructorSignature);
                sConstructorMap.put(name, constructor);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(this.mConstructorArgs);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Context themifyContext(Context context, AttributeSet attrs, boolean useAndroidTheme, boolean useAppTheme) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        int themeId = 0;
        if (useAndroidTheme) {
            themeId = a.getResourceId(R.styleable.View_android_theme, 0);
        }
        if (useAppTheme && themeId == 0 && (themeId = a.getResourceId(R.styleable.View_theme, 0)) != 0) {
            Log.i((String)"AppCompatViewInflater", (String)"app:theme is now deprecated. Please move to using android:theme instead.");
        }
        a.recycle();
        if (!(themeId == 0 || context instanceof ContextThemeWrapper && ((ContextThemeWrapper)((Object)context)).getThemeResId() == themeId)) {
            context = new ContextThemeWrapper((Context)context, themeId);
        }
        return context;
    }
}

