/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v4.internal.view.SupportMenu;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.menu.MenuItemImpl;
import android.support.v7.internal.view.menu.MenuPresenter;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MenuBuilder
implements SupportMenu {
    private static final int[] sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    private final Context mContext;
    private final Resources mResources;
    private boolean mQwertyMode;
    private boolean mShortcutsVisible;
    private Callback mCallback;
    private ArrayList<MenuItemImpl> mItems;
    private ArrayList<MenuItemImpl> mVisibleItems;
    private boolean mIsVisibleItemsStale;
    private ArrayList<MenuItemImpl> mActionItems;
    private ArrayList<MenuItemImpl> mNonActionItems;
    private boolean mIsActionItemsStale;
    private int mDefaultShowAsAction = 0;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    CharSequence mHeaderTitle;
    Drawable mHeaderIcon;
    View mHeaderView;
    private boolean mPreventDispatchingItemsChanged = false;
    private boolean mItemsChangedWhileDispatchPrevented = false;
    private boolean mOptionalIconsVisible = false;
    private boolean mIsClosing = false;
    private ArrayList<MenuItemImpl> mTempShortcutItemList = new ArrayList();
    private CopyOnWriteArrayList<WeakReference<MenuPresenter>> mPresenters = new CopyOnWriteArrayList();
    private MenuItemImpl mExpandedItem;
    private boolean mOverrideVisibleItems;

    public MenuBuilder(Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList();
        this.mVisibleItems = new ArrayList();
        this.mIsVisibleItemsStale = true;
        this.mActionItems = new ArrayList();
        this.mNonActionItems = new ArrayList();
        this.mIsActionItemsStale = true;
        this.setShortcutsVisibleInner(true);
    }

    public MenuBuilder setDefaultShowAsAction(int defaultShowAsAction) {
        this.mDefaultShowAsAction = defaultShowAsAction;
        return this;
    }

    public void addMenuPresenter(MenuPresenter presenter) {
        this.addMenuPresenter(presenter, this.mContext);
    }

    public void addMenuPresenter(MenuPresenter presenter, Context menuContext) {
        this.mPresenters.add(new WeakReference<MenuPresenter>(presenter));
        presenter.initForMenu(menuContext, this);
        this.mIsActionItemsStale = true;
    }

    public void removeMenuPresenter(MenuPresenter presenter) {
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter item = (MenuPresenter)ref.get();
            if (item != null && item != presenter) continue;
            this.mPresenters.remove(ref);
        }
    }

    private void dispatchPresenterUpdate(boolean cleared) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            presenter.updateMenuView(cleared);
        }
        this.startDispatchingItemsChanged();
    }

    private boolean dispatchSubMenuSelected(SubMenuBuilder subMenu, MenuPresenter preferredPresenter) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean result = false;
        if (preferredPresenter != null) {
            result = preferredPresenter.onSubMenuSelected(subMenu);
        }
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            if (result) continue;
            result = presenter.onSubMenuSelected(subMenu);
        }
        return result;
    }

    public void saveActionViewStates(Bundle outStates) {
        SparseArray viewStates = null;
        int itemCount = this.size();
        for (int i = 0; i < itemCount; ++i) {
            MenuItem item = this.getItem(i);
            View v = MenuItemCompat.getActionView(item);
            if (v != null && v.getId() != -1) {
                if (viewStates == null) {
                    viewStates = new SparseArray();
                }
                v.saveHierarchyState(viewStates);
                if (MenuItemCompat.isActionViewExpanded(item)) {
                    outStates.putInt("android:menu:expandedactionview", item.getItemId());
                }
            }
            if (!item.hasSubMenu()) continue;
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            subMenu.saveActionViewStates(outStates);
        }
        if (viewStates != null) {
            outStates.putSparseParcelableArray(this.getActionViewStatesKey(), viewStates);
        }
    }

    public void restoreActionViewStates(Bundle states) {
        MenuItem itemToExpand;
        if (states == null) {
            return;
        }
        SparseArray viewStates = states.getSparseParcelableArray(this.getActionViewStatesKey());
        int itemCount = this.size();
        for (int i = 0; i < itemCount; ++i) {
            MenuItem item = this.getItem(i);
            View v = MenuItemCompat.getActionView(item);
            if (v != null && v.getId() != -1) {
                v.restoreHierarchyState(viewStates);
            }
            if (!item.hasSubMenu()) continue;
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            subMenu.restoreActionViewStates(states);
        }
        int expandedId = states.getInt("android:menu:expandedactionview");
        if (expandedId > 0 && (itemToExpand = this.findItem(expandedId)) != null) {
            MenuItemCompat.expandActionView(itemToExpand);
        }
    }

    protected String getActionViewStatesKey() {
        return "android:menu:actionviewstates";
    }

    public void setCallback(Callback cb) {
        this.mCallback = cb;
    }

    private MenuItem addInternal(int group, int id2, int categoryOrder, CharSequence title) {
        int ordering = MenuBuilder.getOrdering(categoryOrder);
        MenuItemImpl item = this.createNewMenuItem(group, id2, categoryOrder, ordering, title, this.mDefaultShowAsAction);
        if (this.mCurrentMenuInfo != null) {
            item.setMenuInfo(this.mCurrentMenuInfo);
        }
        this.mItems.add(MenuBuilder.findInsertIndex(this.mItems, ordering), item);
        this.onItemsChanged(true);
        return item;
    }

    private MenuItemImpl createNewMenuItem(int group, int id2, int categoryOrder, int ordering, CharSequence title, int defaultShowAsAction) {
        return new MenuItemImpl(this, group, id2, categoryOrder, ordering, title, defaultShowAsAction);
    }

    public MenuItem add(CharSequence title) {
        return this.addInternal(0, 0, 0, title);
    }

    public MenuItem add(int titleRes) {
        return this.addInternal(0, 0, 0, this.mResources.getString(titleRes));
    }

    public MenuItem add(int group, int id2, int categoryOrder, CharSequence title) {
        return this.addInternal(group, id2, categoryOrder, title);
    }

    public MenuItem add(int group, int id2, int categoryOrder, int title) {
        return this.addInternal(group, id2, categoryOrder, this.mResources.getString(title));
    }

    public SubMenu addSubMenu(CharSequence title) {
        return this.addSubMenu(0, 0, 0, title);
    }

    public SubMenu addSubMenu(int titleRes) {
        return this.addSubMenu(0, 0, 0, this.mResources.getString(titleRes));
    }

    public SubMenu addSubMenu(int group, int id2, int categoryOrder, CharSequence title) {
        MenuItemImpl item = (MenuItemImpl)this.addInternal(group, id2, categoryOrder, title);
        SubMenuBuilder subMenu = new SubMenuBuilder(this.mContext, this, item);
        item.setSubMenu(subMenu);
        return subMenu;
    }

    public SubMenu addSubMenu(int group, int id2, int categoryOrder, int title) {
        return this.addSubMenu(group, id2, categoryOrder, this.mResources.getString(title));
    }

    public int addIntentOptions(int group, int id2, int categoryOrder, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        int N;
        PackageManager pm = this.mContext.getPackageManager();
        List lri = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        int n = N = lri != null ? lri.size() : 0;
        if ((flags & 1) == 0) {
            this.removeGroup(group);
        }
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = (ResolveInfo)lri.get(i);
            Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
            rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
            MenuItem item = this.add(group, id2, categoryOrder, ri.loadLabel(pm)).setIcon(ri.loadIcon(pm)).setIntent(rintent);
            if (outSpecificItems == null || ri.specificIndex < 0) continue;
            outSpecificItems[ri.specificIndex] = item;
        }
        return N;
    }

    public void removeItem(int id2) {
        this.removeItemAtInt(this.findItemIndex(id2), true);
    }

    public void removeGroup(int group) {
        int i = this.findGroupIndex(group);
        if (i >= 0) {
            int maxRemovable = this.mItems.size() - i;
            int numRemoved = 0;
            while (numRemoved++ < maxRemovable && this.mItems.get(i).getGroupId() == group) {
                this.removeItemAtInt(i, false);
            }
            this.onItemsChanged(true);
        }
    }

    private void removeItemAtInt(int index, boolean updateChildrenOnMenuViews) {
        if (index < 0 || index >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(index);
        if (updateChildrenOnMenuViews) {
            this.onItemsChanged(true);
        }
    }

    public void clear() {
        if (this.mExpandedItem != null) {
            this.collapseItemActionView(this.mExpandedItem);
        }
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    void setExclusiveItemChecked(MenuItem item) {
        int group = item.getGroupId();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl curItem = this.mItems.get(i);
            if (curItem.getGroupId() != group || !curItem.isExclusiveCheckable() || !curItem.isCheckable()) continue;
            curItem.setCheckedInt(curItem == item);
        }
    }

    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            item.setExclusiveCheckable(exclusive);
            item.setCheckable(checkable);
        }
    }

    public void setGroupVisible(int group, boolean visible) {
        int N = this.mItems.size();
        boolean changedAtLeastOneItem = false;
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group || !item.setVisibleInt(visible)) continue;
            changedAtLeastOneItem = true;
        }
        if (changedAtLeastOneItem) {
            this.onItemsChanged(true);
        }
    }

    public void setGroupEnabled(int group, boolean enabled) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            item.setEnabled(enabled);
        }
    }

    public boolean hasVisibleItems() {
        if (this.mOverrideVisibleItems) {
            return true;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (!item.isVisible()) continue;
            return true;
        }
        return false;
    }

    public MenuItem findItem(int id2) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItem possibleItem;
            MenuItemImpl item = this.mItems.get(i);
            if (item.getItemId() == id2) {
                return item;
            }
            if (!item.hasSubMenu() || (possibleItem = item.getSubMenu().findItem(id2)) == null) continue;
            return possibleItem;
        }
        return null;
    }

    public int findItemIndex(int id2) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getItemId() != id2) continue;
            return i;
        }
        return -1;
    }

    public int findGroupIndex(int group) {
        return this.findGroupIndex(group, 0);
    }

    public int findGroupIndex(int group, int start) {
        int size = this.size();
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.mItems.size();
    }

    public MenuItem getItem(int index) {
        return this.mItems.get(index);
    }

    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return this.findItemWithShortcutForKey(keyCode, event) != null;
    }

    public void setQwertyMode(boolean isQwerty) {
        this.mQwertyMode = isQwerty;
        this.onItemsChanged(false);
    }

    private static int getOrdering(int categoryOrder) {
        int index = (categoryOrder & 0xFFFF0000) >> 16;
        if (index < 0 || index >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[index] << 16 | categoryOrder & 0xFFFF;
    }

    boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    private void setShortcutsVisibleInner(boolean shortcutsVisible) {
        this.mShortcutsVisible = shortcutsVisible && this.mResources.getConfiguration().keyboard != 1 && this.mResources.getBoolean(R.bool.abc_config_showMenuShortcutsWhenKeyboardPresent);
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    Resources getResources() {
        return this.mResources;
    }

    public Context getContext() {
        return this.mContext;
    }

    boolean dispatchMenuItemSelected(MenuBuilder menu2, MenuItem item) {
        return this.mCallback != null && this.mCallback.onMenuItemSelected(menu2, item);
    }

    public void changeMenuMode() {
        if (this.mCallback != null) {
            this.mCallback.onMenuModeChange(this);
        }
    }

    private static int findInsertIndex(ArrayList<MenuItemImpl> items, int ordering) {
        for (int i = items.size() - 1; i >= 0; --i) {
            MenuItemImpl item = items.get(i);
            if (item.getOrdering() > ordering) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        MenuItemImpl item = this.findItemWithShortcutForKey(keyCode, event);
        boolean handled = false;
        if (item != null) {
            handled = this.performItemAction(item, flags);
        }
        if ((flags & 2) != 0) {
            this.close(true);
        }
        return handled;
    }

    void findItemsWithShortcutForKey(List<MenuItemImpl> items, int keyCode, KeyEvent event) {
        boolean qwerty = this.isQwertyMode();
        int metaState = event.getMetaState();
        KeyCharacterMap.KeyData possibleChars = new KeyCharacterMap.KeyData();
        boolean isKeyCodeMapped = event.getKeyData(possibleChars);
        if (!isKeyCodeMapped && keyCode != 67) {
            return;
        }
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            char shortcutChar;
            MenuItemImpl item = this.mItems.get(i);
            if (item.hasSubMenu()) {
                ((MenuBuilder)item.getSubMenu()).findItemsWithShortcutForKey(items, keyCode, event);
            }
            char c = shortcutChar = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if ((metaState & 5) != 0 || shortcutChar == '\u0000' || shortcutChar != possibleChars.meta[0] && shortcutChar != possibleChars.meta[2] && (!qwerty || shortcutChar != '\b' || keyCode != 67) || !item.isEnabled()) continue;
            items.add(item);
        }
    }

    MenuItemImpl findItemWithShortcutForKey(int keyCode, KeyEvent event) {
        ArrayList<MenuItemImpl> items = this.mTempShortcutItemList;
        items.clear();
        this.findItemsWithShortcutForKey(items, keyCode, event);
        if (items.isEmpty()) {
            return null;
        }
        int metaState = event.getMetaState();
        KeyCharacterMap.KeyData possibleChars = new KeyCharacterMap.KeyData();
        event.getKeyData(possibleChars);
        int size = items.size();
        if (size == 1) {
            return items.get(0);
        }
        boolean qwerty = this.isQwertyMode();
        for (int i = 0; i < size; ++i) {
            char shortcutChar;
            MenuItemImpl item = items.get(i);
            char c = shortcutChar = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if (!(shortcutChar == possibleChars.meta[0] && (metaState & 2) == 0 || shortcutChar == possibleChars.meta[2] && (metaState & 2) != 0) && (!qwerty || shortcutChar != '\b' || keyCode != 67)) continue;
            return item;
        }
        return null;
    }

    public boolean performIdentifierAction(int id2, int flags) {
        return this.performItemAction(this.findItem(id2), flags);
    }

    public boolean performItemAction(MenuItem item, int flags) {
        return this.performItemAction(item, null, flags);
    }

    public boolean performItemAction(MenuItem item, MenuPresenter preferredPresenter, int flags) {
        boolean providerHasSubMenu;
        MenuItemImpl itemImpl = (MenuItemImpl)item;
        if (itemImpl == null || !itemImpl.isEnabled()) {
            return false;
        }
        boolean invoked = itemImpl.invoke();
        ActionProvider provider = itemImpl.getSupportActionProvider();
        boolean bl = providerHasSubMenu = provider != null && provider.hasSubMenu();
        if (itemImpl.hasCollapsibleActionView()) {
            if (invoked |= itemImpl.expandActionView()) {
                this.close(true);
            }
        } else if (itemImpl.hasSubMenu() || providerHasSubMenu) {
            this.close(false);
            if (!itemImpl.hasSubMenu()) {
                itemImpl.setSubMenu(new SubMenuBuilder(this.getContext(), this, itemImpl));
            }
            SubMenuBuilder subMenu = (SubMenuBuilder)itemImpl.getSubMenu();
            if (providerHasSubMenu) {
                provider.onPrepareSubMenu(subMenu);
            }
            if (!(invoked |= this.dispatchSubMenuSelected(subMenu, preferredPresenter))) {
                this.close(true);
            }
        } else if ((flags & 1) == 0) {
            this.close(true);
        }
        return invoked;
    }

    public final void close(boolean allMenusAreClosing) {
        if (this.mIsClosing) {
            return;
        }
        this.mIsClosing = true;
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            presenter.onCloseMenu(this, allMenusAreClosing);
        }
        this.mIsClosing = false;
    }

    public void close() {
        this.close(true);
    }

    public void onItemsChanged(boolean structureChanged) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (structureChanged) {
                this.mIsVisibleItemsStale = true;
                this.mIsActionItemsStale = true;
            }
            this.dispatchPresenterUpdate(structureChanged);
        } else {
            this.mItemsChangedWhileDispatchPrevented = true;
        }
    }

    public void stopDispatchingItemsChanged() {
        if (!this.mPreventDispatchingItemsChanged) {
            this.mPreventDispatchingItemsChanged = true;
            this.mItemsChangedWhileDispatchPrevented = false;
        }
    }

    public void startDispatchingItemsChanged() {
        this.mPreventDispatchingItemsChanged = false;
        if (this.mItemsChangedWhileDispatchPrevented) {
            this.mItemsChangedWhileDispatchPrevented = false;
            this.onItemsChanged(true);
        }
    }

    void onItemVisibleChanged(MenuItemImpl item) {
        this.mIsVisibleItemsStale = true;
        this.onItemsChanged(true);
    }

    void onItemActionRequestChanged(MenuItemImpl item) {
        this.mIsActionItemsStale = true;
        this.onItemsChanged(true);
    }

    public ArrayList<MenuItemImpl> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int itemsSize = this.mItems.size();
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (!item.isVisible()) continue;
            this.mVisibleItems.add(item);
        }
        this.mIsVisibleItemsStale = false;
        this.mIsActionItemsStale = true;
        return this.mVisibleItems;
    }

    public void flagActionItems() {
        ArrayList<MenuItemImpl> visibleItems = this.getVisibleItems();
        if (!this.mIsActionItemsStale) {
            return;
        }
        boolean flagged = false;
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            flagged |= presenter.flagActionItems();
        }
        if (flagged) {
            this.mActionItems.clear();
            this.mNonActionItems.clear();
            int itemsSize = visibleItems.size();
            for (int i = 0; i < itemsSize; ++i) {
                MenuItemImpl item = visibleItems.get(i);
                if (item.isActionButton()) {
                    this.mActionItems.add(item);
                    continue;
                }
                this.mNonActionItems.add(item);
            }
        } else {
            this.mActionItems.clear();
            this.mNonActionItems.clear();
            this.mNonActionItems.addAll(this.getVisibleItems());
        }
        this.mIsActionItemsStale = false;
    }

    public ArrayList<MenuItemImpl> getActionItems() {
        this.flagActionItems();
        return this.mActionItems;
    }

    public ArrayList<MenuItemImpl> getNonActionItems() {
        this.flagActionItems();
        return this.mNonActionItems;
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    private void setHeaderInternal(int titleRes, CharSequence title, int iconRes, Drawable icon, View view) {
        Resources r = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (titleRes > 0) {
                this.mHeaderTitle = r.getText(titleRes);
            } else if (title != null) {
                this.mHeaderTitle = title;
            }
            if (iconRes > 0) {
                this.mHeaderIcon = ContextCompat.getDrawable(this.getContext(), iconRes);
            } else if (icon != null) {
                this.mHeaderIcon = icon;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence title) {
        this.setHeaderInternal(0, title, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(Drawable icon) {
        this.setHeaderInternal(0, null, 0, icon, null);
        return this;
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        this.setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public MenuBuilder getRootMenu() {
        return this;
    }

    boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    public boolean expandItemActionView(MenuItemImpl item) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean expanded = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            expanded = presenter.expandItemActionView(this, item);
            if (!expanded) continue;
            break;
        }
        this.startDispatchingItemsChanged();
        if (expanded) {
            this.mExpandedItem = item;
        }
        return expanded;
    }

    public boolean collapseItemActionView(MenuItemImpl item) {
        if (this.mPresenters.isEmpty() || this.mExpandedItem != item) {
            return false;
        }
        boolean collapsed = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            collapsed = presenter.collapseItemActionView(this, item);
            if (!collapsed) continue;
            break;
        }
        this.startDispatchingItemsChanged();
        if (collapsed) {
            this.mExpandedItem = null;
        }
        return collapsed;
    }

    public MenuItemImpl getExpandedItem() {
        return this.mExpandedItem;
    }

    public void setOverrideVisibleItems(boolean override) {
        this.mOverrideVisibleItems = override;
    }

    public static interface ItemInvoker {
        public boolean invokeItem(MenuItemImpl var1);
    }

    public static interface Callback {
        public boolean onMenuItemSelected(MenuBuilder var1, MenuItem var2);

        public void onMenuModeChange(MenuBuilder var1);
    }
}

