/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.ViewPropertyAnimatorCompatSet;
import android.support.v7.widget.ActionMenuPresenter;
import android.support.v7.widget.ActionMenuView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

abstract class AbsActionBarView
extends ViewGroup {
    private static final Interpolator sAlphaInterpolator = new DecelerateInterpolator();
    protected final VisibilityAnimListener mVisAnimListener = new VisibilityAnimListener();
    protected final Context mPopupContext;
    protected ActionMenuView mMenuView;
    protected ActionMenuPresenter mActionMenuPresenter;
    protected ViewGroup mSplitView;
    protected boolean mSplitActionBar;
    protected boolean mSplitWhenNarrow;
    protected int mContentHeight;
    protected ViewPropertyAnimatorCompat mVisibilityAnim;

    AbsActionBarView(Context context) {
        this(context, null);
    }

    AbsActionBarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    AbsActionBarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedValue tv = new TypedValue();
        this.mPopupContext = context.getTheme().resolveAttribute(R.attr.actionBarPopupTheme, tv, true) && tv.resourceId != 0 ? new ContextThemeWrapper(context, tv.resourceId) : context;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(newConfig);
        }
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        this.setContentHeight(a.getLayoutDimension(R.styleable.ActionBar_height, 0));
        a.recycle();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.onConfigurationChanged(newConfig);
        }
    }

    public void setSplitToolbar(boolean split) {
        this.mSplitActionBar = split;
    }

    public void setSplitWhenNarrow(boolean splitWhenNarrow) {
        this.mSplitWhenNarrow = splitWhenNarrow;
    }

    public void setContentHeight(int height) {
        this.mContentHeight = height;
        this.requestLayout();
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public void setSplitView(ViewGroup splitView) {
        this.mSplitView = splitView;
    }

    public int getAnimatedVisibility() {
        if (this.mVisibilityAnim != null) {
            return this.mVisAnimListener.mFinalVisibility;
        }
        return this.getVisibility();
    }

    public void animateToVisibility(int visibility) {
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.cancel();
        }
        if (visibility == 0) {
            if (this.getVisibility() != 0) {
                ViewCompat.setAlpha((View)this, 0.0f);
                if (this.mSplitView != null && this.mMenuView != null) {
                    ViewCompat.setAlpha((View)this.mMenuView, 0.0f);
                }
            }
            ViewPropertyAnimatorCompat anim2 = ViewCompat.animate((View)this).alpha(1.0f);
            anim2.setDuration(200L);
            anim2.setInterpolator(sAlphaInterpolator);
            if (this.mSplitView != null && this.mMenuView != null) {
                ViewPropertyAnimatorCompatSet set = new ViewPropertyAnimatorCompatSet();
                ViewPropertyAnimatorCompat splitAnim = ViewCompat.animate((View)this.mMenuView).alpha(1.0f);
                splitAnim.setDuration(200L);
                set.setListener(this.mVisAnimListener.withFinalVisibility(anim2, visibility));
                set.play(anim2).play(splitAnim);
                set.start();
            } else {
                anim2.setListener(this.mVisAnimListener.withFinalVisibility(anim2, visibility));
                anim2.start();
            }
        } else {
            ViewPropertyAnimatorCompat anim3 = ViewCompat.animate((View)this).alpha(0.0f);
            anim3.setDuration(200L);
            anim3.setInterpolator(sAlphaInterpolator);
            if (this.mSplitView != null && this.mMenuView != null) {
                ViewPropertyAnimatorCompatSet set = new ViewPropertyAnimatorCompatSet();
                ViewPropertyAnimatorCompat splitAnim = ViewCompat.animate((View)this.mMenuView).alpha(0.0f);
                splitAnim.setDuration(200L);
                set.setListener(this.mVisAnimListener.withFinalVisibility(anim3, visibility));
                set.play(anim3).play(splitAnim);
                set.start();
            } else {
                anim3.setListener(this.mVisAnimListener.withFinalVisibility(anim3, visibility));
                anim3.start();
            }
        }
    }

    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.showOverflowMenu();
        }
        return false;
    }

    protected int measureChildView(View child, int availableWidth, int childSpecHeight, int spacing) {
        child.measure(View.MeasureSpec.makeMeasureSpec((int)availableWidth, (int)Integer.MIN_VALUE), childSpecHeight);
        availableWidth -= child.getMeasuredWidth();
        return Math.max(0, availableWidth -= spacing);
    }

    protected static int next(int x, int val, boolean isRtl) {
        return isRtl ? x - val : x + val;
    }

    protected int positionChild(View child, int x, int y, int contentHeight, boolean reverse) {
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        int childTop = y + (contentHeight - childHeight) / 2;
        if (reverse) {
            child.layout(x - childWidth, childTop, x, childTop + childHeight);
        } else {
            child.layout(x, childTop, x + childWidth, childTop + childHeight);
        }
        return reverse ? -childWidth : childWidth;
    }

    protected class VisibilityAnimListener
    implements ViewPropertyAnimatorListener {
        private boolean mCanceled = false;
        int mFinalVisibility;

        protected VisibilityAnimListener() {
        }

        public VisibilityAnimListener withFinalVisibility(ViewPropertyAnimatorCompat animation, int visibility) {
            AbsActionBarView.this.mVisibilityAnim = animation;
            this.mFinalVisibility = visibility;
            return this;
        }

        @Override
        public void onAnimationStart(View view) {
            AbsActionBarView.this.setVisibility(0);
            this.mCanceled = false;
        }

        @Override
        public void onAnimationEnd(View view) {
            if (this.mCanceled) {
                return;
            }
            AbsActionBarView.this.mVisibilityAnim = null;
            AbsActionBarView.this.setVisibility(this.mFinalVisibility);
            if (AbsActionBarView.this.mSplitView != null && AbsActionBarView.this.mMenuView != null) {
                AbsActionBarView.this.mMenuView.setVisibility(this.mFinalVisibility);
            }
        }

        @Override
        public void onAnimationCancel(View view) {
            this.mCanceled = true;
        }
    }
}

