/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.app.ActionBar;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.ActionBarPolicy;
import android.support.v7.internal.widget.AdapterViewCompat;
import android.support.v7.internal.widget.SpinnerCompat;
import android.support.v7.internal.widget.TintTypedArray;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.LinearLayoutCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;

public class ScrollingTabContainerView
extends HorizontalScrollView
implements AdapterViewCompat.OnItemClickListener {
    Runnable mTabSelector;
    private TabClickListener mTabClickListener;
    private LinearLayoutCompat mTabLayout;
    private SpinnerCompat mTabSpinner;
    private boolean mAllowCollapse;
    int mMaxTabWidth;
    int mStackedTabMaxWidth;
    private int mContentHeight;
    private int mSelectedTabIndex;
    private static final Interpolator sAlphaInterpolator = new DecelerateInterpolator();

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean canCollapse;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        boolean lockedExpanded = widthMode == 0x40000000;
        this.setFillViewport(lockedExpanded);
        int childCount = this.mTabLayout.getChildCount();
        if (childCount > 1 && (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE)) {
            this.mMaxTabWidth = childCount > 2 ? (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * 0.4f) : View.MeasureSpec.getSize((int)widthMeasureSpec) / 2;
            this.mMaxTabWidth = Math.min(this.mMaxTabWidth, this.mStackedTabMaxWidth);
        } else {
            this.mMaxTabWidth = -1;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mContentHeight, (int)0x40000000);
        boolean bl = canCollapse = !lockedExpanded && this.mAllowCollapse;
        if (canCollapse) {
            this.mTabLayout.measure(0, heightMeasureSpec);
            if (this.mTabLayout.getMeasuredWidth() > View.MeasureSpec.getSize((int)widthMeasureSpec)) {
                this.performCollapse();
            } else {
                this.performExpand();
            }
        } else {
            this.performExpand();
        }
        int oldWidth = this.getMeasuredWidth();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newWidth = this.getMeasuredWidth();
        if (lockedExpanded && oldWidth != newWidth) {
            this.setTabSelected(this.mSelectedTabIndex);
        }
    }

    private boolean isCollapsed() {
        return this.mTabSpinner != null && this.mTabSpinner.getParent() == this;
    }

    public void setAllowCollapse(boolean allowCollapse) {
        this.mAllowCollapse = allowCollapse;
    }

    private void performCollapse() {
        if (this.isCollapsed()) {
            return;
        }
        if (this.mTabSpinner == null) {
            this.mTabSpinner = this.createSpinner();
        }
        this.removeView((View)this.mTabLayout);
        this.addView((View)this.mTabSpinner, new ViewGroup.LayoutParams(-2, -1));
        if (this.mTabSpinner.getAdapter() == null) {
            this.mTabSpinner.setAdapter((SpinnerAdapter)new TabAdapter());
        }
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
            this.mTabSelector = null;
        }
        this.mTabSpinner.setSelection(this.mSelectedTabIndex);
    }

    private boolean performExpand() {
        if (!this.isCollapsed()) {
            return false;
        }
        this.removeView((View)this.mTabSpinner);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
        this.setTabSelected(this.mTabSpinner.getSelectedItemPosition());
        return false;
    }

    public void setTabSelected(int position) {
        this.mSelectedTabIndex = position;
        int tabCount = this.mTabLayout.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            View child = this.mTabLayout.getChildAt(i);
            boolean isSelected = i == position;
            child.setSelected(isSelected);
            if (!isSelected) continue;
            this.animateToTab(position);
        }
        if (this.mTabSpinner != null && position >= 0) {
            this.mTabSpinner.setSelection(position);
        }
    }

    public void setContentHeight(int contentHeight) {
        this.mContentHeight = contentHeight;
        this.requestLayout();
    }

    private SpinnerCompat createSpinner() {
        SpinnerCompat spinner = new SpinnerCompat(this.getContext(), null, R.attr.actionDropDownStyle);
        spinner.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-2, -1));
        spinner.setOnItemClickListenerInt(this);
        return spinner;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(newConfig);
        }
        ActionBarPolicy abp = ActionBarPolicy.get(this.getContext());
        this.setContentHeight(abp.getTabContainerHeight());
        this.mStackedTabMaxWidth = abp.getStackedTabMaxWidth();
    }

    public void animateToTab(int position) {
        final View tabView = this.mTabLayout.getChildAt(position);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new Runnable(){

            @Override
            public void run() {
                int scrollPos = tabView.getLeft() - (ScrollingTabContainerView.this.getWidth() - tabView.getWidth()) / 2;
                ScrollingTabContainerView.this.smoothScrollTo(scrollPos, 0);
                ScrollingTabContainerView.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabSelector != null) {
            this.post(this.mTabSelector);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
    }

    private TabView createTabView(ActionBar.Tab tab, boolean forAdapter) {
        TabView tabView = new TabView(this.getContext(), tab, forAdapter);
        if (forAdapter) {
            tabView.setBackgroundDrawable(null);
            tabView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, this.mContentHeight));
        } else {
            tabView.setFocusable(true);
            if (this.mTabClickListener == null) {
                this.mTabClickListener = new TabClickListener();
            }
            tabView.setOnClickListener(this.mTabClickListener);
        }
        return tabView;
    }

    @Override
    public void onItemClick(AdapterViewCompat<?> parent, View view, int position, long id2) {
        TabView tabView = (TabView)view;
        tabView.getTab().select();
    }

    private class TabClickListener
    implements View.OnClickListener {
        private TabClickListener() {
        }

        public void onClick(View view) {
            TabView tabView = (TabView)view;
            tabView.getTab().select();
            int tabCount = ScrollingTabContainerView.this.mTabLayout.getChildCount();
            for (int i = 0; i < tabCount; ++i) {
                View child;
                child.setSelected((child = ScrollingTabContainerView.this.mTabLayout.getChildAt(i)) == view);
            }
        }
    }

    private class TabAdapter
    extends BaseAdapter {
        private TabAdapter() {
        }

        public int getCount() {
            return ScrollingTabContainerView.this.mTabLayout.getChildCount();
        }

        public Object getItem(int position) {
            return ((TabView)ScrollingTabContainerView.this.mTabLayout.getChildAt(position)).getTab();
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = ScrollingTabContainerView.this.createTabView((ActionBar.Tab)this.getItem(position), true);
            } else {
                ((TabView)((Object)convertView)).bindTab((ActionBar.Tab)this.getItem(position));
            }
            return convertView;
        }
    }

    private class TabView
    extends LinearLayoutCompat
    implements View.OnLongClickListener {
        private final int[] BG_ATTRS;
        private ActionBar.Tab mTab;
        private TextView mTextView;
        private ImageView mIconView;
        private View mCustomView;

        public TabView(Context context, ActionBar.Tab tab, boolean forList) {
            super(context, null, R.attr.actionBarTabStyle);
            this.BG_ATTRS = new int[]{16842964};
            this.mTab = tab;
            TintTypedArray a = TintTypedArray.obtainStyledAttributes(context, null, this.BG_ATTRS, R.attr.actionBarTabStyle, 0);
            if (a.hasValue(0)) {
                this.setBackgroundDrawable(a.getDrawable(0));
            }
            a.recycle();
            if (forList) {
                this.setGravity(8388627);
            }
            this.update();
        }

        public void bindTab(ActionBar.Tab tab) {
            this.mTab = tab;
            this.update();
        }

        public void setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (changed && selected) {
                this.sendAccessibilityEvent(4);
            }
        }

        @Override
        public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
            event.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
            if (Build.VERSION.SDK_INT >= 14) {
                info.setClassName((CharSequence)ActionBar.Tab.class.getName());
            }
        }

        @Override
        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (ScrollingTabContainerView.this.mMaxTabWidth > 0 && this.getMeasuredWidth() > ScrollingTabContainerView.this.mMaxTabWidth) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)ScrollingTabContainerView.this.mMaxTabWidth, (int)0x40000000), heightMeasureSpec);
            }
        }

        public void update() {
            ActionBar.Tab tab = this.mTab;
            View custom = tab.getCustomView();
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.mCustomView = custom;
                if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                }
                if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
            } else {
                boolean hasText;
                if (this.mCustomView != null) {
                    this.removeView(this.mCustomView);
                    this.mCustomView = null;
                }
                Drawable icon = tab.getIcon();
                CharSequence text = tab.getText();
                if (icon != null) {
                    if (this.mIconView == null) {
                        ImageView iconView = new ImageView(this.getContext());
                        LinearLayoutCompat.LayoutParams lp = new LinearLayoutCompat.LayoutParams(-2, -2);
                        lp.gravity = 16;
                        iconView.setLayoutParams((ViewGroup.LayoutParams)lp);
                        this.addView((View)iconView, 0);
                        this.mIconView = iconView;
                    }
                    this.mIconView.setImageDrawable(icon);
                    this.mIconView.setVisibility(0);
                } else if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
                boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
                if (hasText) {
                    if (this.mTextView == null) {
                        AppCompatTextView textView = new AppCompatTextView(this.getContext(), null, R.attr.actionBarTabTextStyle);
                        textView.setEllipsize(TextUtils.TruncateAt.END);
                        LinearLayoutCompat.LayoutParams lp = new LinearLayoutCompat.LayoutParams(-2, -2);
                        lp.gravity = 16;
                        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
                        this.addView((View)textView);
                        this.mTextView = textView;
                    }
                    this.mTextView.setText(text);
                    this.mTextView.setVisibility(0);
                } else if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                    this.mTextView.setText(null);
                }
                if (this.mIconView != null) {
                    this.mIconView.setContentDescription(tab.getContentDescription());
                }
                if (!hasText && !TextUtils.isEmpty((CharSequence)tab.getContentDescription())) {
                    this.setOnLongClickListener(this);
                } else {
                    this.setOnLongClickListener(null);
                    this.setLongClickable(false);
                }
            }
        }

        public boolean onLongClick(View v) {
            int[] screenPos = new int[2];
            this.getLocationOnScreen(screenPos);
            Context context = this.getContext();
            int width = this.getWidth();
            int height = this.getHeight();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)this.mTab.getContentDescription(), (int)0);
            cheatSheet.setGravity(49, screenPos[0] + width / 2 - screenWidth / 2, height);
            cheatSheet.show();
            return true;
        }

        public ActionBar.Tab getTab() {
            return this.mTab;
        }
    }
}

