/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Shader;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.v4.graphics.drawable.DrawableWrapper;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.internal.widget.TintManager;
import android.support.v7.internal.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.RatingBar;

public class AppCompatRatingBar
extends RatingBar {
    private static final int[] TINT_ATTRS = new int[]{16843067, 16843068};
    private Bitmap mSampleTile;

    public AppCompatRatingBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ratingBarStyle);
    }

    public AppCompatRatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (TintManager.SHOULD_BE_USED) {
            TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.getContext(), attrs, TINT_ATTRS, defStyleAttr, 0);
            Drawable drawable2 = a.getDrawableIfKnown(0);
            if (drawable2 != null) {
                this.setIndeterminateDrawable(this.tileifyIndeterminate(drawable2));
            }
            if ((drawable2 = a.getDrawableIfKnown(1)) != null) {
                this.setProgressDrawable(this.tileify(drawable2, false));
            }
            a.recycle();
        }
    }

    private Drawable tileify(Drawable drawable2, boolean clip) {
        if (drawable2 instanceof DrawableWrapper) {
            Drawable inner = ((DrawableWrapper)drawable2).getWrappedDrawable();
            if (inner != null) {
                inner = this.tileify(inner, clip);
                ((DrawableWrapper)drawable2).setWrappedDrawable(inner);
            }
        } else {
            if (drawable2 instanceof LayerDrawable) {
                LayerDrawable background = (LayerDrawable)drawable2;
                int N = background.getNumberOfLayers();
                Drawable[] outDrawables = new Drawable[N];
                for (int i = 0; i < N; ++i) {
                    int id2 = background.getId(i);
                    outDrawables[i] = this.tileify(background.getDrawable(i), id2 == 16908301 || id2 == 16908303);
                }
                LayerDrawable newBg = new LayerDrawable(outDrawables);
                for (int i = 0; i < N; ++i) {
                    newBg.setId(i, background.getId(i));
                }
                return newBg;
            }
            if (drawable2 instanceof BitmapDrawable) {
                Bitmap tileBitmap = ((BitmapDrawable)drawable2).getBitmap();
                if (this.mSampleTile == null) {
                    this.mSampleTile = tileBitmap;
                }
                ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
                BitmapShader bitmapShader = new BitmapShader(tileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
                shapeDrawable.getPaint().setShader((Shader)bitmapShader);
                return clip ? new ClipDrawable((Drawable)shapeDrawable, 3, 1) : shapeDrawable;
            }
        }
        return drawable2;
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable background = (AnimationDrawable)drawable2;
            int N = background.getNumberOfFrames();
            AnimationDrawable newBg = new AnimationDrawable();
            newBg.setOneShot(background.isOneShot());
            for (int i = 0; i < N; ++i) {
                Drawable frame = this.tileify(background.getFrame(i), true);
                frame.setLevel(10000);
                newBg.addFrame(frame, background.getDuration(i));
            }
            newBg.setLevel(10000);
            drawable2 = newBg;
        }
        return drawable2;
    }

    private Shape getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mSampleTile != null) {
            int width = this.mSampleTile.getWidth() * this.getNumStars();
            this.setMeasuredDimension(ViewCompat.resolveSizeAndState(width, widthMeasureSpec, 0), this.getMeasuredHeight());
        }
    }
}

