/*
 * Decompiled with CFR 0.152.
 */
package com.codebutler.android_websockets;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.net.TrafficStats;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.codebutler.android_websockets.HybiParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;

@TargetApi(value=8)
public class WebSocketClient {
    private int mSocketTag = -1;
    private URI mURI;
    private Listener mListener;
    private DebugListener mDebugListener;
    private Socket mSocket;
    private Thread mThread;
    private static final HandlerThread mHandlerThread = new HandlerThread("websocket-thread");
    private Handler mHandler;
    private List<BasicNameValuePair> mExtraHeaders;
    private HybiParser mParser;
    private String mProxyHost;
    private int mProxyPort;
    static final String[] ENABLED_CIPHERS = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5"};
    static final String[] ENABLED_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private final Object mSendLock = new Object();
    private static TrustManager[] sTrustManagers;
    private ArrayList<Thread> mSocketThreads = new ArrayList();

    public static void setTrustManagers(TrustManager[] tm) {
        sTrustManagers = tm;
    }

    public WebSocketClient(URI uri, Listener listener, List<BasicNameValuePair> extraHeaders) {
        this.mURI = uri;
        this.mListener = listener;
        this.mExtraHeaders = extraHeaders;
        this.mParser = new HybiParser(this);
        if (!mHandlerThread.isAlive()) {
            mHandlerThread.start();
        }
        this.mHandler = new Handler(mHandlerThread.getLooper());
    }

    public Listener getListener() {
        return this.mListener;
    }

    public void connect() {
        if (this.mThread != null && this.mThread.isAlive()) {
            return;
        }
        this.mThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        InetAddress[] addresses;
                        SocketFactory factory;
                        int port = WebSocketClient.this.mURI.getPort() != -1 ? WebSocketClient.this.mURI.getPort() : (WebSocketClient.this.mURI.getScheme().equals("wss") ? 443 : 80);
                        SocketFactory socketFactory = factory = WebSocketClient.this.mURI.getScheme().equals("wss") ? WebSocketClient.this.getSSLSocketFactory() : SocketFactory.getDefault();
                        if (WebSocketClient.this.mProxyHost != null && WebSocketClient.this.mProxyHost.length() > 0) {
                            if (WebSocketClient.this.mDebugListener != null) {
                                WebSocketClient.this.mDebugListener.onDebugMsg("Connecting to proxy: " + WebSocketClient.this.mProxyHost + " port: " + WebSocketClient.this.mProxyPort);
                            }
                            WebSocketClient.this.mSocket = SocketFactory.getDefault().createSocket(WebSocketClient.this.mProxyHost, WebSocketClient.this.mProxyPort);
                            WebSocketClient.this.start_socket_thread();
                            break block6;
                        }
                        for (InetAddress address : addresses = InetAddress.getAllByName(WebSocketClient.this.mURI.getHost())) {
                            if (WebSocketClient.this.mSocket == null) {
                                Thread t = new Thread(new ConnectRunnable(factory, new InetSocketAddress(address, port)));
                                WebSocketClient.this.mSocketThreads.add(t);
                                t.start();
                                Thread.sleep(300L);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception ex) {
                        if (WebSocketClient.this.mListener == null) break block6;
                        WebSocketClient.this.mListener.onError(ex);
                    }
                }
            }
        });
        this.mThread.start();
    }

    private void start_socket_thread() {
        this.mThread = new Thread(new Runnable(){

            @Override
            @SuppressLint(value={"NewApi"})
            public void run() {
                block28: {
                    try {
                        String line;
                        StatusLine statusLine;
                        HybiParser.HappyDataInputStream stream;
                        String path;
                        String secret = WebSocketClient.this.createSecret();
                        int port = WebSocketClient.this.mURI.getPort() != -1 ? WebSocketClient.this.mURI.getPort() : (WebSocketClient.this.mURI.getScheme().equals("wss") ? 443 : 80);
                        String string2 = path = TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getPath()) ? "/" : WebSocketClient.this.mURI.getPath();
                        if (!TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getQuery())) {
                            path = path + "?" + WebSocketClient.this.mURI.getQuery();
                        }
                        String originScheme = WebSocketClient.this.mURI.getScheme().equals("wss") ? "https" : "http";
                        URI origin = new URI(originScheme, "//" + WebSocketClient.this.mURI.getHost(), null);
                        if (Build.VERSION.SDK_INT >= 14 && WebSocketClient.this.mSocketTag > 0) {
                            TrafficStats.setThreadStatsTag((int)WebSocketClient.this.mSocketTag);
                            TrafficStats.tagSocket((Socket)WebSocketClient.this.mSocket);
                        }
                        PrintWriter out = new PrintWriter(WebSocketClient.this.mSocket.getOutputStream());
                        if (WebSocketClient.this.mProxyHost != null && WebSocketClient.this.mProxyHost.length() > 0 && WebSocketClient.this.mProxyPort > 0) {
                            out.print("CONNECT " + WebSocketClient.this.mURI.getHost() + ":" + port + " HTTP/1.0\r\n");
                            out.print("\r\n");
                            out.flush();
                            stream = new HybiParser.HappyDataInputStream(WebSocketClient.this.mSocket.getInputStream());
                            statusLine = WebSocketClient.this.parseStatusLine(WebSocketClient.this.readLine(stream));
                            if (statusLine == null) {
                                throw new HttpException("Received no reply from server.");
                            }
                            if (statusLine.getStatusCode() != 200) {
                                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                            }
                            while (!TextUtils.isEmpty((CharSequence)WebSocketClient.this.readLine(stream))) {
                            }
                            if (WebSocketClient.this.mURI.getScheme().equals("wss")) {
                                WebSocketClient.this.mSocket = WebSocketClient.this.getSSLSocketFactory().createSocket(WebSocketClient.this.mSocket, WebSocketClient.this.mURI.getHost(), port, false);
                                SSLSocket s = (SSLSocket)WebSocketClient.this.mSocket;
                                try {
                                    s.setEnabledProtocols(ENABLED_PROTOCOLS);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                                try {
                                    s.setEnabledCipherSuites(ENABLED_CIPHERS);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                                out = new PrintWriter(WebSocketClient.this.mSocket.getOutputStream());
                            }
                        }
                        if (WebSocketClient.this.mURI.getScheme().equals("wss")) {
                            SSLSocket s = (SSLSocket)WebSocketClient.this.mSocket;
                            StrictHostnameVerifier verifier = new StrictHostnameVerifier();
                            if (!verifier.verify(WebSocketClient.this.mURI.getHost(), s.getSession())) {
                                throw new SSLException("Hostname mismatch");
                            }
                        }
                        out.print("GET " + path + " HTTP/1.1\r\n");
                        out.print("Upgrade: websocket\r\n");
                        out.print("Connection: Upgrade\r\n");
                        out.print("Host: " + WebSocketClient.this.mURI.getHost() + "\r\n");
                        out.print("Origin: " + origin.toString() + "\r\n");
                        out.print("Sec-WebSocket-Key: " + secret + "\r\n");
                        out.print("Sec-WebSocket-Version: 13\r\n");
                        out.print("Sec-WebSocket-Extensions: x-webkit-deflate-frame\r\n");
                        if (WebSocketClient.this.mExtraHeaders != null) {
                            for (NameValuePair pair : WebSocketClient.this.mExtraHeaders) {
                                out.print(String.format("%s: %s\r\n", pair.getName(), pair.getValue()));
                            }
                        }
                        out.print("\r\n");
                        out.flush();
                        stream = new HybiParser.HappyDataInputStream(WebSocketClient.this.mSocket.getInputStream());
                        statusLine = WebSocketClient.this.parseStatusLine(WebSocketClient.this.readLine(stream));
                        if (statusLine == null) {
                            throw new HttpException("Received no reply from server.");
                        }
                        if (statusLine.getStatusCode() != 101) {
                            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                        }
                        boolean validated = false;
                        while (!TextUtils.isEmpty((CharSequence)(line = WebSocketClient.this.readLine(stream)))) {
                            Header header = WebSocketClient.this.parseHeader(line);
                            if (header.getName().equalsIgnoreCase("Sec-WebSocket-Accept")) {
                                String actual;
                                String expected = WebSocketClient.this.createSecretValidation(secret);
                                if (!expected.equals(actual = header.getValue().trim())) {
                                    throw new HttpException("Bad Sec-WebSocket-Accept header value.");
                                }
                                validated = true;
                                continue;
                            }
                            if (!header.getName().equalsIgnoreCase("Sec-WebSocket-Extensions") || !header.getValue().trim().equalsIgnoreCase("x-webkit-deflate-frame")) continue;
                            WebSocketClient.this.mParser.setDeflate(true);
                        }
                        if (!validated) {
                            throw new HttpException("No Sec-WebSocket-Accept header.");
                        }
                        if (WebSocketClient.this.mListener != null) {
                            WebSocketClient.this.mListener.onConnect();
                        }
                        WebSocketClient.this.mParser.start(stream);
                    }
                    catch (EOFException ex) {
                        Log.d((String)"WebSocketClient", (String)"WebSocket EOF!", (Throwable)ex);
                        if (WebSocketClient.this.mListener != null) {
                            WebSocketClient.this.mListener.onDisconnect(0, "EOF");
                        }
                    }
                    catch (SSLException ex) {
                        Log.d((String)"WebSocketClient", (String)"Websocket SSL error!", (Throwable)ex);
                        if (WebSocketClient.this.mListener != null) {
                            WebSocketClient.this.mListener.onDisconnect(0, "SSL");
                        }
                    }
                    catch (Exception ex) {
                        if (WebSocketClient.this.mListener == null) break block28;
                        WebSocketClient.this.mListener.onError(ex);
                    }
                }
            }
        });
        this.mThread.setName("websocket-parser-thread");
        this.mThread.start();
    }

    public void disconnect() {
        if (this.mSocket != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            if (WebSocketClient.this.mSocket != null) {
                                WebSocketClient.this.mSocket.close();
                            }
                            WebSocketClient.this.mSocket = null;
                        }
                        catch (IOException ex) {
                            Log.d((String)"WebSocketClient", (String)"Error while disconnecting", (Throwable)ex);
                            if (WebSocketClient.this.mListener == null) break block3;
                            WebSocketClient.this.mListener.onError(ex);
                        }
                    }
                }
            });
        }
    }

    public void send(String data) {
        this.sendFrame(this.mParser.frame(data));
    }

    private StatusLine parseStatusLine(String line) {
        if (TextUtils.isEmpty((CharSequence)line)) {
            return null;
        }
        return BasicLineParser.parseStatusLine((String)line, (LineParser)new BasicLineParser());
    }

    private Header parseHeader(String line) {
        return BasicLineParser.parseHeader((String)line, (LineParser)new BasicLineParser());
    }

    private String readLine(HybiParser.HappyDataInputStream reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuilder string2 = new StringBuilder("");
        while (readChar != 10) {
            if (readChar != 13) {
                string2.append((char)readChar);
            }
            if ((readChar = reader.read()) != -1) continue;
            return null;
        }
        return string2.toString();
    }

    private String createSecret() {
        byte[] nonce = new byte[16];
        for (int i = 0; i < 16; ++i) {
            nonce[i] = (byte)(Math.random() * 256.0);
        }
        return Base64.encodeToString((byte[])nonce, (int)0).trim();
    }

    private String createSecretValidation(String secret) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update((secret + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes());
            return Base64.encodeToString((byte[])md.digest(), (int)0).trim();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    void sendFrame(final byte[] frame) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @SuppressLint(value={"NewApi"})
            public void run() {
                block8: {
                    try {
                        Object object = WebSocketClient.this.mSendLock;
                        synchronized (object) {
                            if (WebSocketClient.this.mSocket == null) {
                                if (WebSocketClient.this.mListener != null) {
                                    WebSocketClient.this.mListener.onError(new IllegalStateException("Socket not connected"));
                                }
                                return;
                            }
                            OutputStream outputStream = WebSocketClient.this.mSocket.getOutputStream();
                            outputStream.write(frame);
                            outputStream.flush();
                            if (Build.VERSION.SDK_INT >= 14) {
                                TrafficStats.incrementOperationCount((int)1);
                            }
                        }
                    }
                    catch (IOException e) {
                        if (WebSocketClient.this.mListener == null) break block8;
                        WebSocketClient.this.mListener.onError(e);
                    }
                }
            }
        });
    }

    public void setSocketTag(int tag) {
        this.mSocketTag = tag;
        if (Build.VERSION.SDK_INT >= 14 && this.mSocketTag > 0 && this.mSocket != null) {
            this.mHandler.post(new Runnable(){

                @Override
                @TargetApi(value=14)
                public void run() {
                    block2: {
                        try {
                            TrafficStats.setThreadStatsTag((int)WebSocketClient.this.mSocketTag);
                            TrafficStats.tagSocket((Socket)WebSocketClient.this.mSocket);
                        }
                        catch (SocketException e) {
                            if (WebSocketClient.this.mListener == null) break block2;
                            WebSocketClient.this.mListener.onError(e);
                        }
                    }
                }
            });
        }
    }

    public void setProxy(String host, int port) {
        this.mProxyHost = host;
        this.mProxyPort = port;
    }

    private SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, sTrustManagers, null);
        return context.getSocketFactory();
    }

    public static interface DebugListener {
        public void onDebugMsg(String var1);
    }

    public static interface Listener {
        public void onConnect();

        public void onMessage(String var1);

        public void onMessage(byte[] var1);

        public void onDisconnect(int var1, String var2);

        public void onError(Exception var1);
    }

    private class ConnectRunnable
    implements Runnable {
        private SocketFactory mSocketFactory;
        private InetSocketAddress mAddress;

        ConnectRunnable(SocketFactory factory, InetSocketAddress address) {
            this.mSocketFactory = factory;
            this.mAddress = address;
        }

        @Override
        public void run() {
            block13: {
                try {
                    if (WebSocketClient.this.mDebugListener != null) {
                        WebSocketClient.this.mDebugListener.onDebugMsg("Connecting to address: " + this.mAddress.getAddress() + " port: " + this.mAddress.getPort());
                    }
                    Socket socket = this.mSocketFactory.createSocket();
                    socket.connect(this.mAddress, 30000);
                    if (WebSocketClient.this.mSocket == null) {
                        WebSocketClient.this.mSocket = socket;
                        if (WebSocketClient.this.mDebugListener != null) {
                            WebSocketClient.this.mDebugListener.onDebugMsg("Connected to " + this.mAddress.getAddress());
                        }
                        if (WebSocketClient.this.mURI.getScheme().equals("wss")) {
                            SSLSocket s = (SSLSocket)WebSocketClient.this.mSocket;
                            try {
                                s.setEnabledProtocols(ENABLED_PROTOCOLS);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            try {
                                s.setEnabledCipherSuites(ENABLED_CIPHERS);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        WebSocketClient.this.start_socket_thread();
                        break block13;
                    }
                    socket.close();
                }
                catch (SSLException ex) {
                    ex.printStackTrace();
                    if (WebSocketClient.this.mSocket == null && WebSocketClient.this.mSocketThreads.size() == 1) {
                        Log.d((String)"WebSocketClient", (String)"Websocket SSL error!", (Throwable)ex);
                        if (WebSocketClient.this.mListener != null) {
                            WebSocketClient.this.mListener.onDisconnect(0, "SSL");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (WebSocketClient.this.mSocket != null || WebSocketClient.this.mSocketThreads.size() != 1 || WebSocketClient.this.mListener == null) break block13;
                    WebSocketClient.this.mListener.onError(ex);
                }
            }
            WebSocketClient.this.mSocketThreads.remove(Thread.currentThread());
        }
    }
}

