/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;

class ClsFileOutputStream
extends FileOutputStream {
    private final String root;
    private File inProgress;
    private File complete;
    private boolean closed = false;
    public static final FilenameFilter TEMP_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.endsWith(".cls_temp");
        }
    };

    public ClsFileOutputStream(File dir, String fileRoot) throws FileNotFoundException {
        super(new File(dir, fileRoot + ".cls_temp"));
        this.root = dir + File.separator + fileRoot;
        this.inProgress = new File(this.root + ".cls_temp");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.flush();
        super.close();
        File complete = new File(this.root + ".cls");
        if (!this.inProgress.renameTo(complete)) {
            String reason = "";
            if (complete.exists()) {
                reason = " (target already exists)";
            } else if (!this.inProgress.exists()) {
                reason = " (source does not exist)";
            }
            throw new IOException("Could not rename temp file: " + this.inProgress + " -> " + complete + reason);
        }
        this.inProgress = null;
        this.complete = complete;
    }

    public void closeInProgressStream() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.flush();
        super.close();
    }
}

