/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.view.View;
import android.widget.ScrollView;
import android.widget.TextView;
import com.crashlytics.android.BuildIdValidator;
import com.crashlytics.android.CrashTest;
import com.crashlytics.android.CrashlyticsExecutorServiceWrapper;
import com.crashlytics.android.CrashlyticsListener;
import com.crashlytics.android.CrashlyticsMissingDependencyException;
import com.crashlytics.android.CrashlyticsPinningInfoProvider;
import com.crashlytics.android.CrashlyticsUncaughtExceptionHandler;
import com.crashlytics.android.CreateReportSpiCall;
import com.crashlytics.android.DefaultCreateReportSpiCall;
import com.crashlytics.android.DialogStringResolver;
import com.crashlytics.android.PinningInfoProvider;
import com.crashlytics.android.ReportUploader;
import com.crashlytics.android.SessionDataWriter;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.beta.Beta;
import com.crashlytics.android.internal.CrashEventDataProvider;
import com.crashlytics.android.internal.models.SessionEventData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.KitGroup;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.Crash;
import io.fabric.sdk.android.services.common.ExecutorUtils;
import io.fabric.sdk.android.services.concurrency.DependsOn;
import io.fabric.sdk.android.services.concurrency.Priority;
import io.fabric.sdk.android.services.concurrency.PriorityCallable;
import io.fabric.sdk.android.services.concurrency.Task;
import io.fabric.sdk.android.services.concurrency.UnmetDependencyException;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.FileStoreImpl;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.PromptSettingsData;
import io.fabric.sdk.android.services.settings.SessionSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@DependsOn(value={CrashEventDataProvider.class})
public class Crashlytics
extends Kit<Void>
implements KitGroup {
    private final long startTime;
    private final ConcurrentHashMap<String, String> attributes = new ConcurrentHashMap();
    private final Collection<Kit<Boolean>> kits;
    private File initializationMarkerFile;
    private CrashlyticsListener listener;
    private CrashlyticsUncaughtExceptionHandler handler;
    private String userId = null;
    private String userEmail = null;
    private String userName = null;
    private String buildId;
    private String packageName;
    private String installerPackageName;
    private String versionCode;
    private String versionName;
    private float delay;
    private boolean disabled;
    private final PinningInfoProvider pinningInfo;
    private HttpRequestFactory httpRequestFactory;
    private CrashlyticsExecutorServiceWrapper executorServiceWrapper;
    private CrashEventDataProvider externalCrashEventDataProvider;

    public Crashlytics() {
        this(1.0f, null, null, false);
    }

    Crashlytics(float delay, CrashlyticsListener listener, PinningInfoProvider pinningInfo, boolean disabled) {
        this(delay, listener, pinningInfo, disabled, ExecutorUtils.buildSingleThreadExecutorService("Crashlytics Exception Handler"));
    }

    Crashlytics(float delay, CrashlyticsListener listener, PinningInfoProvider pinningInfo, boolean disabled, ExecutorService crashHandlerExecutor) {
        this.startTime = System.currentTimeMillis();
        this.delay = delay;
        this.listener = listener;
        this.pinningInfo = pinningInfo;
        this.disabled = disabled;
        this.executorServiceWrapper = new CrashlyticsExecutorServiceWrapper(crashHandlerExecutor);
        this.kits = Collections.unmodifiableCollection(Arrays.asList(new Answers(), new Beta()));
    }

    @Override
    protected boolean onPreExecute() {
        Context context = super.getContext();
        return this.onPreExecute(context);
    }

    boolean onPreExecute(Context context) {
        if (this.disabled) {
            return false;
        }
        String apiKey = new ApiKey().getValue(context);
        if (apiKey == null) {
            return false;
        }
        Fabric.getLogger().i("Fabric", "Initializing Crashlytics " + this.getVersion());
        this.initializationMarkerFile = new File(this.getSdkDirectory(), "initialization_marker");
        try {
            boolean initializeSynchronously = false;
            this.setAndValidateKitProperties(context, apiKey);
            try {
                SessionDataWriter sessionDataWriter = new SessionDataWriter(this.getContext(), this.buildId, this.getPackageName());
                Fabric.getLogger().d("Fabric", "Installing exception handler...");
                this.handler = new CrashlyticsUncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler(), this.listener, this.executorServiceWrapper, this.getIdManager(), sessionDataWriter, this);
                initializeSynchronously = this.didPreviousInitializationComplete();
                this.handler.ensureOpenSessionExists();
                Thread.setDefaultUncaughtExceptionHandler(this.handler);
                Fabric.getLogger().d("Fabric", "Successfully installed exception handler.");
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "There was a problem installing the exception handler.", e);
            }
            if (initializeSynchronously && CommonUtils.canTryConnection(context)) {
                this.finishInitSynchronously();
                return false;
            }
            return true;
        }
        catch (CrashlyticsMissingDependencyException e) {
            throw new UnmetDependencyException(e);
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Crashlytics was not started due to an exception during initialization", e);
            return false;
        }
    }

    private void setAndValidateKitProperties(Context context, String apiKey) {
        CrashlyticsPinningInfoProvider infoProvider = this.pinningInfo != null ? new CrashlyticsPinningInfoProvider(this.pinningInfo) : null;
        this.httpRequestFactory = new DefaultHttpRequestFactory(Fabric.getLogger());
        this.httpRequestFactory.setPinningInfoProvider(infoProvider);
        try {
            this.packageName = context.getPackageName();
            this.installerPackageName = this.getIdManager().getInstallerPackageName();
            Fabric.getLogger().d("Fabric", "Installer package name is: " + this.installerPackageName);
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.packageName, 0);
            this.versionCode = Integer.toString(packageInfo.versionCode);
            this.versionName = packageInfo.versionName == null ? "0.0" : packageInfo.versionName;
            this.buildId = CommonUtils.resolveBuildId(context);
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Error setting up app properties", e);
        }
        this.getIdManager().getBluetoothMacAddress();
        this.getBuildIdValidator(this.buildId, this.isRequiringBuildId(context)).validate(apiKey, this.packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() {
        this.markInitializationStarted();
        this.handler.cleanInvalidTempFiles();
        try {
            SettingsData settingsData;
            boolean reportingDisabled;
            block13: {
                reportingDisabled = true;
                settingsData = Settings.getInstance().awaitSettingsData();
                if (settingsData != null) break block13;
                Fabric.getLogger().w("Fabric", "Received null settings, skipping initialization!");
                Void void_ = null;
                return void_;
            }
            try {
                if (settingsData.featuresData.collectReports) {
                    reportingDisabled = false;
                    this.handler.finalizeSessions();
                    CreateReportSpiCall call = this.getCreateReportSpiCall(settingsData);
                    if (call != null) {
                        new ReportUploader(call).uploadReports(this.delay);
                    } else {
                        Fabric.getLogger().w("Fabric", "Unable to create a call to upload reports.");
                    }
                }
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Error dealing with settings", e);
            }
            if (reportingDisabled) {
                Fabric.getLogger().d("Fabric", "Crash reporting disabled.");
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Problem encountered during Crashlytics initialization.", e);
        }
        finally {
            this.markInitializationComplete();
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "com.crashlytics.sdk.android:crashlytics";
    }

    @Override
    public String getVersion() {
        return "2.2.4.42";
    }

    @Override
    public Collection<? extends Kit> getKits() {
        return this.kits;
    }

    public static Crashlytics getInstance() {
        try {
            return Fabric.getKit(Crashlytics.class);
        }
        catch (IllegalStateException ex) {
            Fabric.getLogger().e("Fabric", "Crashlytics must be initialized by calling Fabric.with(Context) prior to calling Crashlytics.getInstance()", null);
            throw ex;
        }
    }

    public static void logException(Throwable throwable) {
        if (Crashlytics.isDisabled()) {
            return;
        }
        Crashlytics instance = Crashlytics.getInstance();
        if (Crashlytics.ensureFabricWithCalled("prior to logging exceptions.", instance)) {
            if (throwable == null) {
                Fabric.getLogger().log(5, "Fabric", "Crashlytics is ignoring a request to log a null exception.");
                return;
            }
            instance.handler.writeNonFatalException(Thread.currentThread(), throwable);
        }
    }

    public static void log(String msg) {
        Crashlytics.doLog(3, "Fabric", msg);
    }

    private static void doLog(int priority, String tag, String msg) {
        if (Crashlytics.isDisabled()) {
            return;
        }
        Crashlytics instance = Crashlytics.getInstance();
        if (Crashlytics.ensureFabricWithCalled("prior to logging messages.", instance)) {
            long timestamp = System.currentTimeMillis() - instance.startTime;
            instance.handler.writeToLog(timestamp, Crashlytics.formatLogMessage(priority, tag, msg));
        }
    }

    public static void log(int priority, String tag, String msg) {
        Crashlytics.doLog(priority, tag, msg);
        Fabric.getLogger().log(priority, "" + tag, "" + msg, true);
    }

    public static void setUserIdentifier(String identifier) {
        if (Crashlytics.isDisabled()) {
            return;
        }
        Crashlytics.getInstance().userId = Crashlytics.sanitizeAttribute(identifier);
    }

    public void crash() {
        new CrashTest().indexOutOfBounds();
    }

    private void finishInitSynchronously() {
        PriorityCallable<Void> callable = new PriorityCallable<Void>(){

            @Override
            public Void call() throws Exception {
                return Crashlytics.this.doInBackground();
            }

            @Override
            public Priority getPriority() {
                return Priority.IMMEDIATE;
            }
        };
        for (Task task : this.getDependencies()) {
            callable.addDependency(task);
        }
        Future<Void> future = this.getFabric().getExecutorService().submit(callable);
        Fabric.getLogger().d("Fabric", "Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(4L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Fabric.getLogger().e("Fabric", "Crashlytics was interrupted during initialization.", e);
        }
        catch (ExecutionException e) {
            Fabric.getLogger().e("Fabric", "Problem encountered during Crashlytics initialization.", e);
        }
        catch (TimeoutException e) {
            Fabric.getLogger().e("Fabric", "Crashlytics timed out during initialization.", e);
        }
    }

    static void recordLoggedExceptionEvent(String sessionId) {
        Answers answers = Fabric.getKit(Answers.class);
        if (answers != null) {
            answers.onException(new Crash.LoggedException(sessionId));
        }
    }

    static void recordFatalExceptionEvent(String sessionId) {
        Answers answers = Fabric.getKit(Answers.class);
        if (answers != null) {
            answers.onException(new Crash.FatalException(sessionId));
        }
    }

    Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    BuildIdValidator getBuildIdValidator(String buildId, boolean requireBuildId) {
        return new BuildIdValidator(buildId, requireBuildId);
    }

    String getPackageName() {
        return this.packageName;
    }

    String getInstallerPackageName() {
        return this.installerPackageName;
    }

    String getVersionName() {
        return this.versionName;
    }

    String getVersionCode() {
        return this.versionCode;
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue(Crashlytics.getInstance().getContext(), "com.crashlytics.ApiEndpoint");
    }

    CrashlyticsUncaughtExceptionHandler getHandler() {
        return this.handler;
    }

    String getUserIdentifier() {
        return this.getIdManager().canCollectUserIds() ? this.userId : null;
    }

    String getUserEmail() {
        return this.getIdManager().canCollectUserIds() ? this.userEmail : null;
    }

    String getUserName() {
        return this.getIdManager().canCollectUserIds() ? this.userName : null;
    }

    void markInitializationStarted() {
        this.executorServiceWrapper.executeSyncLoggingException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Crashlytics.this.initializationMarkerFile.createNewFile();
                Fabric.getLogger().d("Fabric", "Initialization marker file created.");
                return null;
            }
        });
    }

    void markInitializationComplete() {
        this.executorServiceWrapper.executeAsync(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = Crashlytics.this.initializationMarkerFile.delete();
                    Fabric.getLogger().d("Fabric", "Initialization marker file removed: " + removed);
                    return removed;
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Fabric", "Problem encountered deleting Crashlytics initialization marker.", e);
                    return false;
                }
            }
        });
    }

    boolean didPreviousInitializationComplete() {
        return this.executorServiceWrapper.executeSyncLoggingException(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Crashlytics.this.initializationMarkerFile.exists();
            }
        });
    }

    SessionEventData getExternalCrashEventData() {
        SessionEventData eventData = null;
        if (this.externalCrashEventDataProvider != null) {
            eventData = this.externalCrashEventDataProvider.getCrashEventData();
        }
        return eventData;
    }

    File getSdkDirectory() {
        return new FileStoreImpl(this).getFilesDir();
    }

    boolean shouldPromptUserBeforeSendingCrashReports() {
        return Settings.getInstance().withSettings(new Settings.SettingsAccess<Boolean>(){

            @Override
            public Boolean usingSettings(SettingsData settingsData) {
                if (settingsData.featuresData.promptEnabled) {
                    return !Crashlytics.this.shouldSendReportsWithoutPrompting();
                }
                return false;
            }
        }, false);
    }

    boolean shouldSendReportsWithoutPrompting() {
        PreferenceStoreImpl prefStore = new PreferenceStoreImpl(this);
        return prefStore.get().getBoolean("always_send_reports_opt_in", false);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    void setShouldSendUserReportsWithoutPrompting(boolean send) {
        PreferenceStoreImpl prefStore = new PreferenceStoreImpl(this);
        prefStore.save(prefStore.edit().putBoolean("always_send_reports_opt_in", send));
    }

    boolean canSendWithUserApproval() {
        return Settings.getInstance().withSettings(new Settings.SettingsAccess<Boolean>(){

            @Override
            public Boolean usingSettings(SettingsData settingsData) {
                boolean send = true;
                Activity activity = Crashlytics.this.getFabric().getCurrentActivity();
                if (activity != null && !activity.isFinishing() && Crashlytics.this.shouldPromptUserBeforeSendingCrashReports()) {
                    send = Crashlytics.this.getSendDecisionFromUser(activity, settingsData.promptData);
                }
                return send;
            }
        }, true);
    }

    CreateReportSpiCall getCreateReportSpiCall(SettingsData settingsData) {
        if (settingsData != null) {
            return new DefaultCreateReportSpiCall(this, this.getOverridenSpiEndpoint(), settingsData.appData.reportsUrl, this.httpRequestFactory);
        }
        return null;
    }

    private boolean getSendDecisionFromUser(Activity context, final PromptSettingsData promptData) {
        final DialogStringResolver stringResolver = new DialogStringResolver((Context)context, promptData);
        final OptInLatch latch = new OptInLatch();
        final Activity activity = context;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                DialogInterface.OnClickListener sendClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        latch.setOptIn(true);
                        dialog.dismiss();
                    }
                };
                float density = activity.getResources().getDisplayMetrics().density;
                int textViewPadding = Crashlytics.this.dipsToPixels(density, 5);
                TextView textView = new TextView((Context)activity);
                textView.setAutoLinkMask(15);
                textView.setText((CharSequence)stringResolver.getMessage());
                textView.setTextAppearance((Context)activity, 16973892);
                textView.setPadding(textViewPadding, textViewPadding, textViewPadding, textViewPadding);
                textView.setFocusable(false);
                ScrollView scrollView = new ScrollView((Context)activity);
                scrollView.setPadding(Crashlytics.this.dipsToPixels(density, 14), Crashlytics.this.dipsToPixels(density, 2), Crashlytics.this.dipsToPixels(density, 10), Crashlytics.this.dipsToPixels(density, 12));
                scrollView.addView((View)textView);
                builder.setView((View)scrollView).setTitle((CharSequence)stringResolver.getTitle()).setCancelable(false).setNeutralButton((CharSequence)stringResolver.getSendButtonTitle(), sendClickListener);
                if (promptData.showCancelButton) {
                    DialogInterface.OnClickListener cancelClickListener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id2) {
                            latch.setOptIn(false);
                            dialog.dismiss();
                        }
                    };
                    builder.setNegativeButton((CharSequence)stringResolver.getCancelButtonTitle(), cancelClickListener);
                }
                if (promptData.showAlwaysSendButton) {
                    DialogInterface.OnClickListener alwaysSendClickListener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id2) {
                            Crashlytics.this.setShouldSendUserReportsWithoutPrompting(true);
                            latch.setOptIn(true);
                            dialog.dismiss();
                        }
                    };
                    builder.setPositiveButton((CharSequence)stringResolver.getAlwaysSendButtonTitle(), alwaysSendClickListener);
                }
                builder.show();
            }
        });
        Fabric.getLogger().d("Fabric", "Waiting for user opt-in.");
        latch.await();
        return latch.getOptIn();
    }

    SessionSettingsData getSessionSettingsData() {
        SettingsData settingsData = Settings.getInstance().awaitSettingsData();
        return settingsData == null ? null : settingsData.sessionData;
    }

    private boolean isRequiringBuildId(Context context) {
        return CommonUtils.getBooleanResourceValue(context, "com.crashlytics.RequireBuildId", true);
    }

    private static String formatLogMessage(int priority, String tag, String msg) {
        return CommonUtils.logPriorityToString(priority) + "/" + tag + " " + msg;
    }

    private static boolean ensureFabricWithCalled(String msg, Crashlytics instance) {
        if (instance == null || instance.handler == null) {
            Fabric.getLogger().e("Fabric", "Crashlytics must be initialized by calling Fabric.with(Context) " + msg, null);
            return false;
        }
        return true;
    }

    private static String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > 1024) {
            input = input.substring(0, 1024);
        }
        return input;
    }

    private static boolean isDisabled() {
        Crashlytics instance = Crashlytics.getInstance();
        return instance == null || instance.disabled;
    }

    private int dipsToPixels(float density, int dips) {
        return (int)(density * (float)dips);
    }

    private class OptInLatch {
        private boolean send = false;
        private final CountDownLatch latch = new CountDownLatch(1);

        private OptInLatch() {
        }

        void setOptIn(boolean optIn) {
            this.send = optIn;
            this.latch.countDown();
        }

        boolean getOptIn() {
            return this.send;
        }

        void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

