/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.crashlytics.android.CLSUUID;
import com.crashlytics.android.ClsFileOutputStream;
import com.crashlytics.android.CodedOutputStream;
import com.crashlytics.android.Crashlytics;
import com.crashlytics.android.CrashlyticsExecutorServiceWrapper;
import com.crashlytics.android.CrashlyticsListener;
import com.crashlytics.android.CreateReportSpiCall;
import com.crashlytics.android.ExceptionUtils;
import com.crashlytics.android.LogFileManager;
import com.crashlytics.android.NativeCrashWriter;
import com.crashlytics.android.ReportUploader;
import com.crashlytics.android.SessionDataWriter;
import com.crashlytics.android.SessionReport;
import com.crashlytics.android.Utils;
import com.crashlytics.android.internal.models.SessionEventData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeliveryMechanism;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.settings.SessionSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    static final FilenameFilter SESSION_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.length() == 35 + ".cls".length() && filename.endsWith(".cls");
        }
    };
    static final Comparator<File> LARGEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file2.getName().compareTo(file1.getName());
        }
    };
    static final Comparator<File> SMALLEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareTo(file2.getName());
        }
    };
    static final FilenameFilter ANY_SESSION_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String filename) {
            return SESSION_FILE_PATTERN.matcher(filename).matches();
        }
    };
    private static final Pattern SESSION_FILE_PATTERN = Pattern.compile("([\\d|A-Z|a-z]{12}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{12}).+");
    private static final Map<String, String> SEND_AT_CRASHTIME_HEADER = Collections.singletonMap("X-CRASHLYTICS-SEND-FLAGS", "1");
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    private final AtomicBoolean receiversRegistered = new AtomicBoolean(false);
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final File filesDir;
    private final AtomicBoolean isHandlingException;
    private final BroadcastReceiver powerDisconnectedReceiver;
    private final BroadcastReceiver powerConnectedReceiver;
    private final CrashlyticsExecutorServiceWrapper executorServiceWrapper;
    private final IdManager idManager;
    private boolean powerConnected;
    private final Crashlytics crashlytics;
    private final LogFileManager logFileManager;
    private final SessionDataWriter sessionDataWriter;

    CrashlyticsUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler, CrashlyticsListener listener, CrashlyticsExecutorServiceWrapper executorServiceWrapper, IdManager idManager, SessionDataWriter sessionDataWriter, Crashlytics crashlytics) {
        this.defaultHandler = handler;
        this.executorServiceWrapper = executorServiceWrapper;
        this.idManager = idManager;
        this.crashlytics = crashlytics;
        this.sessionDataWriter = sessionDataWriter;
        this.isHandlingException = new AtomicBoolean(false);
        this.filesDir = crashlytics.getSdkDirectory();
        this.logFileManager = new LogFileManager(crashlytics.getContext(), this.filesDir);
        this.notifyCrashlyticsListenerOfPreviousCrash(listener);
        this.powerConnectedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CrashlyticsUncaughtExceptionHandler.this.powerConnected = true;
            }
        };
        IntentFilter powerConnectedFilter = new IntentFilter("android.intent.action.ACTION_POWER_CONNECTED");
        this.powerDisconnectedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CrashlyticsUncaughtExceptionHandler.this.powerConnected = false;
            }
        };
        IntentFilter powerDisconnectedFilter = new IntentFilter("android.intent.action.ACTION_POWER_DISCONNECTED");
        Context context = crashlytics.getContext();
        context.registerReceiver(this.powerConnectedReceiver, powerConnectedFilter);
        context.registerReceiver(this.powerDisconnectedReceiver, powerDisconnectedFilter);
        this.receiversRegistered.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void uncaughtException(final Thread thread, final Throwable ex) {
        this.isHandlingException.set(true);
        try {
            Fabric.getLogger().d("Fabric", "Crashlytics is handling uncaught exception \"" + ex + "\" from thread " + thread.getName());
            if (!this.receiversRegistered.getAndSet(true)) {
                Fabric.getLogger().d("Fabric", "Unregistering power receivers.");
                Context context = this.crashlytics.getContext();
                context.unregisterReceiver(this.powerConnectedReceiver);
                context.unregisterReceiver(this.powerDisconnectedReceiver);
            }
            final Date now = new Date();
            this.executorServiceWrapper.executeSyncLoggingException(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CrashlyticsUncaughtExceptionHandler.this.handleUncaughtException(now, thread, ex);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "An error occurred in the uncaught exception handler", e);
        }
        finally {
            Fabric.getLogger().d("Fabric", "Crashlytics completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    private void handleUncaughtException(Date time, Thread thread, Throwable ex) throws Exception {
        this.writeFatal(time, thread, ex);
        this.doCloseSessions();
        this.doOpenSession();
        this.trimSessionFiles();
        if (!this.crashlytics.shouldPromptUserBeforeSendingCrashReports()) {
            this.sendSessionReports();
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    private void notifyCrashlyticsListenerOfPreviousCrash(CrashlyticsListener listener) {
        Fabric.getLogger().d("Fabric", "Checking for previous crash marker.");
        File markerFile = new File(this.crashlytics.getSdkDirectory(), "crash_marker");
        if (markerFile.exists()) {
            markerFile.delete();
            if (listener != null) {
                try {
                    listener.crashlyticsDidDetectCrashDuringPreviousExecution();
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Fabric", "Exception thrown by CrashlyticsListener while notifying of previous crash.", e);
                }
            }
        }
    }

    void writeToLog(final long timestamp, final String msg) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.logFileManager.writeToLog(timestamp, msg);
                }
                return null;
            }
        });
    }

    void writeNonFatalException(final Thread thread, final Throwable ex) {
        final Date now = new Date();
        this.executorServiceWrapper.executeAsync(new Runnable(){

            @Override
            public void run() {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.doWriteNonFatal(now, thread, ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatal(Date time, Thread thread, Throwable ex) {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            new File(this.filesDir, "crash_marker").createNewFile();
            String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId != null) {
                Crashlytics.recordFatalExceptionEvent(currentSessionId);
                fos = new ClsFileOutputStream(this.filesDir, currentSessionId + "SessionCrash");
                cos = CodedOutputStream.newInstance(fos);
                this.writeSessionEvent(cos, time, thread, ex, "crash", true);
            } else {
                Fabric.getLogger().e("Fabric", "Tried to write a fatal exception while no session was open.", null);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "An error occurred in the fatal exception logger", e);
            ExceptionUtils.writeStackTraceIfNotNull(e, fos);
        }
        finally {
            CommonUtils.flushOrLog(cos, "Failed to flush to session begin file.");
            CommonUtils.closeOrLog(fos, "Failed to close fatal exception file output stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalCrashEvent(SessionEventData crashEventData) throws IOException {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId != null) {
                Crashlytics.recordFatalExceptionEvent(currentSessionId);
                fos = new ClsFileOutputStream(this.filesDir, currentSessionId + "SessionCrash");
                cos = CodedOutputStream.newInstance(fos);
                NativeCrashWriter.writeNativeCrash(crashEventData, cos);
            } else {
                Fabric.getLogger().e("Fabric", "Tried to write a native crash while no session was open.", null);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "An error occurred in the native crash logger", e);
            ExceptionUtils.writeStackTraceIfNotNull(e, fos);
        }
        finally {
            CommonUtils.flushOrLog(cos, "Failed to flush to session begin file.");
            CommonUtils.closeOrLog(fos, "Failed to close fatal exception file output stream.");
        }
    }

    void ensureOpenSessionExists() {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.hasOpenSession()) {
                    CrashlyticsUncaughtExceptionHandler.this.doOpenSession();
                }
                return null;
            }
        });
    }

    private String getCurrentSessionId() {
        File[] sessionBeginFiles = this.listFilesMatching(new FileNameContainsFilter("BeginSession"));
        Arrays.sort(sessionBeginFiles, LARGEST_FILE_NAME_FIRST);
        return sessionBeginFiles.length > 0 ? this.getSessionIdFromSessionFile(sessionBeginFiles[0]) : null;
    }

    private String getSessionIdFromSessionFile(File sessionFile) {
        return sessionFile.getName().substring(0, 35);
    }

    boolean hasOpenSession() {
        return this.listSessionBeginFiles().length > 0;
    }

    boolean finalizeSessions() {
        return this.executorServiceWrapper.executeSyncLoggingException(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    SessionEventData crashEventData = CrashlyticsUncaughtExceptionHandler.this.crashlytics.getExternalCrashEventData();
                    if (crashEventData != null) {
                        CrashlyticsUncaughtExceptionHandler.this.writeExternalCrashEvent(crashEventData);
                    }
                    CrashlyticsUncaughtExceptionHandler.this.doCloseSessions();
                    CrashlyticsUncaughtExceptionHandler.this.doOpenSession();
                    Fabric.getLogger().d("Fabric", "Open sessions were closed and a new session was opened.");
                    return true;
                }
                Fabric.getLogger().d("Fabric", "Skipping session finalization because a crash has already occurred.");
                return false;
            }
        });
    }

    private void doOpenSession() throws Exception {
        Date startedAt = new Date();
        String sessionIdentifier = new CLSUUID(this.idManager).toString();
        Fabric.getLogger().d("Fabric", "Opening an new session with ID " + sessionIdentifier);
        this.writeBeginSession(sessionIdentifier, startedAt);
        this.writeSessionApp(sessionIdentifier);
        this.writeSessionOS(sessionIdentifier);
        this.writeSessionDevice(sessionIdentifier);
    }

    private void doCloseSessions() throws Exception {
        this.trimOpenSessions(8);
        String currentSessionId = this.getCurrentSessionId();
        if (currentSessionId != null) {
            this.writeSessionUser(currentSessionId);
            SessionSettingsData settingsData = this.crashlytics.getSessionSettingsData();
            if (settingsData != null) {
                int maxLoggedExceptionsCount = settingsData.maxCustomExceptionEvents;
                Fabric.getLogger().d("Fabric", "Closing all open sessions.");
                File[] sessionBeginFiles = this.listSessionBeginFiles();
                if (sessionBeginFiles != null && sessionBeginFiles.length > 0) {
                    for (File sessionBeginFile : sessionBeginFiles) {
                        String sessionIdentifier = this.getSessionIdFromSessionFile(sessionBeginFile);
                        Fabric.getLogger().d("Fabric", "Closing session: " + sessionIdentifier);
                        this.writeSessionPartsToSessionFile(sessionBeginFile, sessionIdentifier, maxLoggedExceptionsCount);
                    }
                }
            } else {
                Fabric.getLogger().d("Fabric", "Unable to close session. Settings are not loaded.");
            }
        } else {
            Fabric.getLogger().d("Fabric", "No open sessions exist.");
        }
    }

    private void closeWithoutRenamingOrLog(ClsFileOutputStream fos) {
        if (fos != null) {
            try {
                fos.closeInProgressStream();
            }
            catch (IOException ex) {
                Fabric.getLogger().e("Fabric", "Error closing session file stream in the presence of an exception", ex);
            }
        }
    }

    private void deleteSessionPartFilesFor(String sessionId) {
        for (File file : this.listSessionPartFilesFor(sessionId)) {
            file.delete();
        }
    }

    private File[] listSessionPartFilesFor(String sessionId) {
        return this.listFilesMatching(new SessionPartFileFilter(sessionId));
    }

    private File[] listCompleteSessionFiles() {
        return this.listFilesMatching(SESSION_FILE_FILTER);
    }

    File[] listSessionBeginFiles() {
        return this.listFilesMatching(new FileNameContainsFilter("BeginSession"));
    }

    private File[] listFilesMatching(FilenameFilter filter) {
        return this.ensureFileArrayNotNull(this.filesDir.listFiles(filter));
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private void trimSessionEventFiles(String sessionId, int limit) {
        Utils.capFileCount(this.filesDir, new FileNameContainsFilter(sessionId + "SessionEvent"), limit, SMALLEST_FILE_NAME_FIRST);
    }

    void trimSessionFiles() {
        Utils.capFileCount(this.filesDir, SESSION_FILE_FILTER, 4, SMALLEST_FILE_NAME_FIRST);
    }

    private void trimOpenSessions(int maxOpenSessionCount) {
        File[] allSessionPartFiles;
        HashSet<String> sessionIdsToKeep = new HashSet<String>();
        File[] beginSessionFiles = this.listSessionBeginFiles();
        Arrays.sort(beginSessionFiles, LARGEST_FILE_NAME_FIRST);
        int count = Math.min(maxOpenSessionCount, beginSessionFiles.length);
        for (int i = 0; i < count; ++i) {
            String sessionId = this.getSessionIdFromSessionFile(beginSessionFiles[i]);
            sessionIdsToKeep.add(sessionId);
        }
        for (File sessionPartFile : allSessionPartFiles = this.listFilesMatching(new AnySessionPartFileFilter())) {
            String fileName = sessionPartFile.getName();
            Matcher matcher = SESSION_FILE_PATTERN.matcher(fileName);
            matcher.matches();
            String sessionId = matcher.group(1);
            if (sessionIdsToKeep.contains(sessionId)) continue;
            Fabric.getLogger().d("Fabric", "Trimming open session file: " + fileName);
            sessionPartFile.delete();
        }
    }

    void cleanInvalidTempFiles() {
        this.executorServiceWrapper.executeAsync(new Runnable(){

            @Override
            public void run() {
                CrashlyticsUncaughtExceptionHandler.this.doCleanInvalidTempFiles(CrashlyticsUncaughtExceptionHandler.this.listFilesMatching(ClsFileOutputStream.TEMP_FILENAME_FILTER));
            }
        });
    }

    void doCleanInvalidTempFiles(File[] invalidFiles) {
        this.deleteLegacyInvalidCacheDir();
        for (File invalidFile : invalidFiles) {
            Fabric.getLogger().d("Fabric", "Found invalid session part file: " + invalidFile);
            final String sessionId = this.getSessionIdFromSessionFile(invalidFile);
            FilenameFilter sessionFilter = new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    return name.startsWith(sessionId);
                }
            };
            Fabric.getLogger().d("Fabric", "Deleting all part files for invalid session: " + sessionId);
            for (File sessionFile : this.listFilesMatching(sessionFilter)) {
                Fabric.getLogger().d("Fabric", "Deleting session file: " + sessionFile);
                sessionFile.delete();
            }
        }
    }

    private void deleteLegacyInvalidCacheDir() {
        File cacheDir = new File(this.crashlytics.getSdkDirectory(), "invalidClsFiles");
        if (cacheDir.exists()) {
            if (cacheDir.isDirectory()) {
                for (File cacheFile : cacheDir.listFiles()) {
                    cacheFile.delete();
                }
            }
            cacheDir.delete();
        }
    }

    private void writeBeginSession(String sessionId, Date startedAt) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + "BeginSession");
            cos = CodedOutputStream.newInstance(fos);
            String generator = String.format(Locale.US, "Crashlytics Android SDK/%s", this.crashlytics.getVersion());
            long startedAtSeconds = startedAt.getTime() / 1000L;
            this.sessionDataWriter.writeBeginSession(cos, sessionId, generator, startedAtSeconds);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, "Failed to flush to session begin file.");
                CommonUtils.closeOrLog(fos, "Failed to close begin session file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog(cos, "Failed to flush to session begin file.");
        CommonUtils.closeOrLog(fos, "Failed to close begin session file.");
    }

    private void writeSessionApp(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + "SessionApp");
            cos = CodedOutputStream.newInstance(fos);
            String packageName = this.crashlytics.getPackageName();
            String versionCode = this.crashlytics.getVersionCode();
            String versionName = this.crashlytics.getVersionName();
            String installUuid = this.idManager.getAppInstallIdentifier();
            int deliveryMechanism = DeliveryMechanism.determineFrom(this.crashlytics.getInstallerPackageName()).getId();
            this.sessionDataWriter.writeSessionApp(cos, packageName, versionCode, versionName, installUuid, deliveryMechanism);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, "Failed to flush to session app file.");
                CommonUtils.closeOrLog(fos, "Failed to close session app file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog(cos, "Failed to flush to session app file.");
        CommonUtils.closeOrLog(fos, "Failed to close session app file.");
    }

    private void writeSessionOS(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + "SessionOS");
            cos = CodedOutputStream.newInstance(fos);
            boolean isRooted = CommonUtils.isRooted(this.crashlytics.getContext());
            this.sessionDataWriter.writeSessionOS(cos, isRooted);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, "Failed to flush to session OS file.");
                CommonUtils.closeOrLog(fos, "Failed to close session OS file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog(cos, "Failed to flush to session OS file.");
        CommonUtils.closeOrLog(fos, "Failed to close session OS file.");
    }

    private void writeSessionDevice(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + "SessionDevice");
            cos = CodedOutputStream.newInstance(fos);
            Context context = this.crashlytics.getContext();
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            String clsDeviceId = this.idManager.getDeviceUUID();
            int arch = CommonUtils.getCpuArchitectureInt();
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            long totalRam = CommonUtils.getTotalRamInBytes();
            long diskSpace = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            boolean isEmulator = CommonUtils.isEmulator(context);
            Map<IdManager.DeviceIdentifierType, String> ids = this.idManager.getDeviceIdentifiers();
            int state = CommonUtils.getDeviceState(context);
            this.sessionDataWriter.writeSessionDevice(cos, clsDeviceId, arch, Build.MODEL, availableProcessors, totalRam, diskSpace, isEmulator, ids, state, Build.MANUFACTURER, Build.PRODUCT);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, "Failed to flush session device info.");
                CommonUtils.closeOrLog(fos, "Failed to close session device file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog(cos, "Failed to flush session device info.");
        CommonUtils.closeOrLog(fos, "Failed to close session device file.");
    }

    private void writeSessionUser(String sessionId) throws Exception {
        String email;
        String name;
        String id2;
        CodedOutputStream cos;
        ClsFileOutputStream fos;
        block5: {
            fos = null;
            cos = null;
            fos = new ClsFileOutputStream(this.filesDir, sessionId + "SessionUser");
            cos = CodedOutputStream.newInstance(fos);
            id2 = this.crashlytics.getUserIdentifier();
            name = this.crashlytics.getUserName();
            email = this.crashlytics.getUserEmail();
            if (id2 != null || name != null || email != null) break block5;
            CommonUtils.flushOrLog(cos, "Failed to flush session user file.");
            CommonUtils.closeOrLog(fos, "Failed to close session user file.");
            return;
        }
        try {
            this.sessionDataWriter.writeSessionUser(cos, id2, name, email);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, "Failed to flush session user file.");
                CommonUtils.closeOrLog(fos, "Failed to close session user file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog(cos, "Failed to flush session user file.");
        CommonUtils.closeOrLog(fos, "Failed to close session user file.");
    }

    private void writeSessionEvent(CodedOutputStream cos, Date time, Thread thread, Throwable ex, String eventType, boolean includeAllThreads) throws Exception {
        Map<Object, Object> attributes;
        Thread[] threads;
        Context context = this.crashlytics.getContext();
        long eventTime = time.getTime() / 1000L;
        float batteryLevel = CommonUtils.getBatteryLevel(context);
        int batteryVelocity = CommonUtils.getBatteryVelocity(context, this.powerConnected);
        boolean proximityEnabled = CommonUtils.getProximitySensorEnabled(context);
        int orientation = context.getResources().getConfiguration().orientation;
        long usedRamBytes = CommonUtils.getTotalRamInBytes() - CommonUtils.calculateFreeRamInBytes(context);
        long diskUsedBytes = CommonUtils.calculateUsedDiskSpaceInBytes(Environment.getDataDirectory().getPath());
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = CommonUtils.getAppProcessInfo(context.getPackageName(), context);
        LinkedList<StackTraceElement[]> stacks = new LinkedList<StackTraceElement[]>();
        StackTraceElement[] exceptionStack = ex.getStackTrace();
        if (includeAllThreads) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            threads = new Thread[allStackTraces.size()];
            int i = 0;
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                threads[i] = entry.getKey();
                stacks.add(entry.getValue());
                ++i;
            }
        } else {
            threads = new Thread[]{};
        }
        if (!CommonUtils.getBooleanResourceValue(context, "com.crashlytics.CollectCustomKeys", true)) {
            attributes = new TreeMap();
        } else {
            attributes = this.crashlytics.getAttributes();
            if (attributes != null && attributes.size() > 1) {
                attributes = new TreeMap<Object, Object>(attributes);
            }
        }
        this.sessionDataWriter.writeSessionEvent(cos, eventTime, thread, ex, eventType, threads, batteryLevel, batteryVelocity, proximityEnabled, orientation, usedRamBytes, diskUsedBytes, runningAppProcessInfo, stacks, exceptionStack, this.logFileManager, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteNonFatal(Date time, Thread thread, Throwable ex) {
        block9: {
            block8: {
                String currentSessionId;
                block7: {
                    currentSessionId = this.getCurrentSessionId();
                    if (currentSessionId == null) break block8;
                    Crashlytics.recordLoggedExceptionEvent(currentSessionId);
                    ClsFileOutputStream fos = null;
                    CodedOutputStream cos = null;
                    try {
                        Fabric.getLogger().d("Fabric", "Crashlytics is logging non-fatal exception \"" + ex + "\" from thread " + thread.getName());
                        String counterString = CommonUtils.padWithZerosToMaxIntWidth(this.eventCounter.getAndIncrement());
                        String nonFatalFileName = currentSessionId + "SessionEvent" + counterString;
                        fos = new ClsFileOutputStream(this.filesDir, nonFatalFileName);
                        cos = CodedOutputStream.newInstance(fos);
                        this.writeSessionEvent(cos, time, thread, ex, "error", false);
                        CommonUtils.flushOrLog(cos, "Failed to flush to non-fatal file.");
                    }
                    catch (Exception e) {
                        Fabric.getLogger().e("Fabric", "An error occurred in the non-fatal exception logger", e);
                        ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                        break block7;
                    }
                    finally {
                        CommonUtils.flushOrLog(cos, "Failed to flush to non-fatal file.");
                        CommonUtils.closeOrLog(fos, "Failed to close non-fatal file output stream.");
                    }
                    CommonUtils.closeOrLog(fos, "Failed to close non-fatal file output stream.");
                }
                try {
                    this.trimSessionEventFiles(currentSessionId, 64);
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Fabric", "An error occurred when trimming non-fatal files.", e);
                }
                break block9;
            }
            Fabric.getLogger().e("Fabric", "Tried to write a non-fatal exception while no session was open.", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionPartsToSessionFile(File sessionBeginFile, String sessionId, int maxLoggedExceptionsCount) {
        block13: {
            block14: {
                Fabric.getLogger().d("Fabric", "Collecting session parts for ID " + sessionId);
                File[] fatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + "SessionCrash"));
                boolean hasFatal = fatalFiles != null && fatalFiles.length > 0;
                Fabric.getLogger().d("Fabric", String.format(Locale.US, "Session %s has fatal exception: %s", sessionId, hasFatal));
                File[] nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + "SessionEvent"));
                boolean hasNonFatal = nonFatalFiles != null && nonFatalFiles.length > 0;
                Fabric.getLogger().d("Fabric", String.format(Locale.US, "Session %s has non-fatal exceptions: %s", sessionId, hasNonFatal));
                if (!hasFatal && !hasNonFatal) break block14;
                ClsFileOutputStream fos = null;
                CodedOutputStream cos = null;
                boolean exceptionDuringWrite = false;
                try {
                    fos = new ClsFileOutputStream(this.filesDir, sessionId);
                    cos = CodedOutputStream.newInstance(fos);
                    Fabric.getLogger().d("Fabric", "Collecting SessionStart data for session ID " + sessionId);
                    this.writeToCosFromFile(cos, sessionBeginFile);
                    cos.writeUInt64(4, new Date().getTime() / 1000L);
                    cos.writeBool(5, hasFatal);
                    this.writeInitialPartsTo(cos, sessionId);
                    if (hasNonFatal) {
                        if (nonFatalFiles.length > maxLoggedExceptionsCount) {
                            Fabric.getLogger().d("Fabric", String.format(Locale.US, "Trimming down to %d logged exceptions.", maxLoggedExceptionsCount));
                            this.trimSessionEventFiles(sessionId, maxLoggedExceptionsCount);
                            nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + "SessionEvent"));
                        }
                        this.writeNonFatalEventsTo(cos, nonFatalFiles, sessionId);
                    }
                    if (hasFatal) {
                        this.writeToCosFromFile(cos, fatalFiles[0]);
                    }
                    cos.writeUInt32(11, 1);
                    cos.writeEnum(12, 3);
                }
                catch (Exception e) {
                    try {
                        Fabric.getLogger().e("Fabric", "Failed to write session file for session ID: " + sessionId, e);
                        ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                        exceptionDuringWrite = true;
                    }
                    catch (Throwable throwable) {
                        CommonUtils.flushOrLog(cos, "Error flushing session file stream");
                        if (exceptionDuringWrite) {
                            this.closeWithoutRenamingOrLog(fos);
                        } else {
                            CommonUtils.closeOrLog(fos, "Failed to close CLS file");
                        }
                        throw throwable;
                    }
                    CommonUtils.flushOrLog(cos, "Error flushing session file stream");
                    if (exceptionDuringWrite) {
                        this.closeWithoutRenamingOrLog(fos);
                    } else {
                        CommonUtils.closeOrLog(fos, "Failed to close CLS file");
                    }
                    break block13;
                }
                CommonUtils.flushOrLog(cos, "Error flushing session file stream");
                if (exceptionDuringWrite) {
                    this.closeWithoutRenamingOrLog(fos);
                } else {
                    CommonUtils.closeOrLog(fos, "Failed to close CLS file");
                }
                break block13;
            }
            Fabric.getLogger().d("Fabric", "No events present for session ID " + sessionId);
        }
        Fabric.getLogger().d("Fabric", "Removing session part files for ID " + sessionId);
        this.deleteSessionPartFilesFor(sessionId);
    }

    private void writeNonFatalEventsTo(CodedOutputStream cos, File[] nonFatalFiles, String sessionId) {
        Arrays.sort(nonFatalFiles, CommonUtils.FILE_MODIFIED_COMPARATOR);
        for (File nonFatalFile : nonFatalFiles) {
            try {
                Fabric.getLogger().d("Fabric", String.format(Locale.US, "Found Non Fatal for session ID %s in %s ", sessionId, nonFatalFile.getName()));
                this.writeToCosFromFile(cos, nonFatalFile);
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Error writting non-fatal to session.", e);
            }
        }
    }

    private void writeInitialPartsTo(CodedOutputStream cos, String sessionId) throws IOException {
        String[] tags;
        for (String tag : tags = new String[]{"SessionUser", "SessionApp", "SessionOS", "SessionDevice"}) {
            File[] sessionPartFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + tag));
            if (sessionPartFiles.length == 0) {
                Fabric.getLogger().e("Fabric", "Can't find " + tag + " data for session ID " + sessionId, null);
                continue;
            }
            Fabric.getLogger().d("Fabric", "Collecting " + tag + " data for session ID " + sessionId);
            this.writeToCosFromFile(cos, sessionPartFiles[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCosFromFile(CodedOutputStream cos, File file) throws IOException {
        if (file.exists()) {
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                int numRead = 0;
                for (int offset = 0; offset < bytes.length && (numRead = fis.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            finally {
                CommonUtils.closeOrLog(fis, "Failed to close file input stream.");
            }
            cos.writeRawBytes(bytes);
        } else {
            Fabric.getLogger().e("Fabric", "Tried to include a file that doesn't exist: " + file.getName(), null);
        }
    }

    private void sendSessionReports() {
        File[] arr$ = this.listCompleteSessionFiles();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File finishedSessionFile;
            final File toSend = finishedSessionFile = arr$[i$];
            this.executorServiceWrapper.executeAsync(new Runnable(){

                @Override
                public void run() {
                    if (CommonUtils.canTryConnection(CrashlyticsUncaughtExceptionHandler.this.crashlytics.getContext())) {
                        Fabric.getLogger().d("Fabric", "Attempting to send crash report at time of crash...");
                        SettingsData settingsData = Settings.getInstance().awaitSettingsData();
                        CreateReportSpiCall call = CrashlyticsUncaughtExceptionHandler.this.crashlytics.getCreateReportSpiCall(settingsData);
                        if (call != null) {
                            new ReportUploader(call).forceUpload(new SessionReport(toSend, SEND_AT_CRASHTIME_HEADER));
                        }
                    }
                }
            });
        }
    }

    private static class AnySessionPartFileFilter
    implements FilenameFilter {
        private AnySessionPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return !SESSION_FILE_FILTER.accept(file, fileName) && SESSION_FILE_PATTERN.matcher(fileName).matches();
        }
    }

    static class SessionPartFileFilter
    implements FilenameFilter {
        private final String sessionId;

        public SessionPartFileFilter(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public boolean accept(File file, String fileName) {
            if (fileName.equals(this.sessionId + ".cls")) {
                return false;
            }
            return fileName.contains(this.sessionId) && !fileName.endsWith(".cls_temp");
        }
    }

    static class FileNameContainsFilter
    implements FilenameFilter {
        private final String string;

        public FileNameContainsFilter(String s) {
            this.string = s;
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.contains(this.string) && !filename.endsWith(".cls_temp");
        }
    }
}

