/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import com.crashlytics.android.Crashlytics;
import com.crashlytics.android.CreateReportRequest;
import com.crashlytics.android.CreateReportSpiCall;
import com.crashlytics.android.Report;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.common.ResponseParser;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import java.util.Map;

class DefaultCreateReportSpiCall
extends AbstractSpiCall
implements CreateReportSpiCall {
    public DefaultCreateReportSpiCall(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory) {
        super(kit, protocolAndHostOverride, url, requestFactory, HttpMethod.POST);
    }

    @Override
    public boolean invoke(CreateReportRequest requestData) {
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = this.applyHeadersTo(httpRequest, requestData);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData);
        Fabric.getLogger().d("Fabric", "Sending report to: " + this.getUrl());
        int statusCode = httpRequest.code();
        Fabric.getLogger().d("Fabric", "Create report request ID: " + httpRequest.header("X-REQUEST-ID"));
        Fabric.getLogger().d("Fabric", "Result was: " + statusCode);
        return 0 == ResponseParser.parse(statusCode);
    }

    private HttpRequest applyHeadersTo(HttpRequest request, CreateReportRequest requestData) {
        request = request.header("X-CRASHLYTICS-API-KEY", requestData.apiKey).header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", Crashlytics.getInstance().getVersion());
        Map<String, String> customHeaders = requestData.report.getCustomHeaders();
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            request = request.header(entry);
        }
        return request;
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, CreateReportRequest requestData) {
        Report report = requestData.report;
        return request.part("report[file]", report.getFileName(), "application/octet-stream", report.getFile()).part("report[identifier]", report.getIdentifier());
    }
}

