/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

final class ExceptionUtils {
    public static void writeStackTraceIfNotNull(Throwable ex, OutputStream os) {
        if (os != null) {
            ExceptionUtils.writeStackTrace(ex, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStackTrace(Throwable ex, OutputStream os) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(os);
            ExceptionUtils.writeStackTrace(ex, writer);
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Failed to create PrintWriter", e);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close stack trace writer.");
        }
    }

    private static void writeStackTrace(Throwable ex, Writer writer) {
        try {
            boolean first = true;
            while (ex != null) {
                String message = ExceptionUtils.getMessage(ex);
                message = message != null ? message : "";
                String causedBy = first ? "" : "Caused by: ";
                writer.write(causedBy + ex.getClass().getName() + ": " + message + "\n");
                first = false;
                for (StackTraceElement element : ex.getStackTrace()) {
                    writer.write("\tat " + element.toString() + "\n");
                }
                ex = ex.getCause();
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Could not write stack trace", e);
        }
    }

    private static String getMessage(Throwable t) {
        String message = t.getLocalizedMessage();
        if (message == null) {
            return null;
        }
        return message.replaceAll("(\r\n|\n|\f)", " ");
    }
}

