/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import android.content.Context;
import com.crashlytics.android.ByteString;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.QueueFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.UUID;

class LogFileManager {
    private final Context context;
    private final File filesDir;
    private QueueFile logFile;

    public LogFileManager(Context context, File filesDir) {
        this(context, filesDir, null);
    }

    LogFileManager(Context context, File filesDir, QueueFile logFile) {
        this.context = context;
        this.filesDir = filesDir;
        this.logFile = logFile;
    }

    public void writeToLog(long timestamp, String msg) {
        if (this.logFile == null) {
            this.initLogFile();
        }
        this.doWriteToLog(65536, timestamp, msg);
    }

    private boolean initLogFile() {
        boolean collectLogs = CommonUtils.getBooleanResourceValue(this.context, "com.crashlytics.CollectCustomLogs", true);
        if (!collectLogs) {
            Fabric.getLogger().d("Fabric", "Preferences requested no custom logs. Aborting log file creation.");
            return false;
        }
        CommonUtils.closeOrLog(this.logFile, "Could not close log file: " + this.logFile);
        File f = null;
        try {
            String filename = "crashlytics-userlog-" + UUID.randomUUID().toString() + ".temp";
            f = new File(this.filesDir, filename);
            this.logFile = new QueueFile(f);
            f.delete();
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Could not create log file: " + f, e);
            return false;
        }
        return true;
    }

    void doWriteToLog(int maxLogSize, long timestamp, String msg) {
        if (this.logFile == null) {
            return;
        }
        if (msg == null) {
            msg = "null";
        }
        try {
            int quarterMaxLogSize = maxLogSize / 4;
            if (msg.length() > quarterMaxLogSize) {
                msg = "..." + msg.substring(msg.length() - quarterMaxLogSize);
            }
            msg = msg.replaceAll("\r", " ");
            msg = msg.replaceAll("\n", " ");
            byte[] msgBytes = String.format(Locale.US, "%d %s%n", timestamp, msg).getBytes("UTF-8");
            this.logFile.add(msgBytes);
            while (!this.logFile.isEmpty() && this.logFile.usedBytes() > maxLogSize) {
                this.logFile.remove();
            }
        }
        catch (IOException e) {
            Fabric.getLogger().e("Fabric", "There was a problem writing to the Crashlytics log.", e);
        }
    }

    ByteString getByteStringForLog() {
        if (this.logFile == null) {
            return null;
        }
        final int[] offsetHolder = new int[]{0};
        final byte[] logBytes = new byte[this.logFile.usedBytes()];
        try {
            this.logFile.forEach(new QueueFile.ElementReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void read(InputStream in, int length) throws IOException {
                    try {
                        in.read(logBytes, offsetHolder[0], length);
                        offsetHolder[0] = offsetHolder[0] + length;
                    }
                    finally {
                        in.close();
                    }
                }
            });
        }
        catch (IOException e) {
            Fabric.getLogger().e("Fabric", "A problem occurred while reading the Crashlytics log file.", e);
        }
        return ByteString.copyFrom(logBytes, 0, offsetHolder[0]);
    }

    void closeLogFile() {
        CommonUtils.closeOrLog(this.logFile, "There was a problem closing the Crashlytics log file.");
        this.logFile = null;
    }
}

