/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import com.crashlytics.android.ByteString;
import com.crashlytics.android.CodedOutputStream;
import com.crashlytics.android.LogFileManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.IdManager;
import java.util.List;
import java.util.Map;

class SessionDataWriter {
    private static final ByteString SIGNAL_DEFAULT_BYTE_STRING = ByteString.copyFromUtf8("0");
    private ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
    private Thread[] threads;
    private List<StackTraceElement[]> stacks;
    private StackTraceElement[] exceptionStack;
    private final Context context;
    private final ByteString packageNameBytes;
    private final ByteString optionalBuildIdBytes;
    private final int maxChainedExceptionsDepth;

    public SessionDataWriter(Context context, String buildId, String packageName) {
        this.maxChainedExceptionsDepth = 8;
        this.context = context;
        this.packageNameBytes = ByteString.copyFromUtf8(packageName);
        this.optionalBuildIdBytes = buildId == null ? null : ByteString.copyFromUtf8(buildId.replace("-", ""));
    }

    public void writeBeginSession(CodedOutputStream cos, String sessionId, String generator, long startedAtSeconds) throws Exception {
        cos.writeBytes(1, ByteString.copyFromUtf8(generator));
        cos.writeBytes(2, ByteString.copyFromUtf8(sessionId));
        cos.writeUInt64(3, startedAtSeconds);
    }

    public void writeSessionApp(CodedOutputStream cos, String packageName, String versionCode, String versionName, String installUuid, int deliveryMechanism) throws Exception {
        ByteString packageNameBytes = ByteString.copyFromUtf8(packageName);
        ByteString versionCodeBytes = ByteString.copyFromUtf8(versionCode);
        ByteString versionNameBytes = ByteString.copyFromUtf8(versionName);
        ByteString installIdBytes = ByteString.copyFromUtf8(installUuid);
        cos.writeTag(7, 2);
        cos.writeRawVarint32(this.getSessionAppSize(packageNameBytes, versionCodeBytes, versionNameBytes, installIdBytes, deliveryMechanism));
        cos.writeBytes(1, packageNameBytes);
        cos.writeBytes(2, versionCodeBytes);
        cos.writeBytes(3, versionNameBytes);
        cos.writeTag(5, 2);
        cos.writeRawVarint32(this.getSessionAppOrgSize());
        cos.writeString(1, new ApiKey().getValue(this.context));
        cos.writeBytes(6, installIdBytes);
        cos.writeEnum(10, deliveryMechanism);
    }

    public void writeSessionOS(CodedOutputStream cos, boolean isRooted) throws Exception {
        ByteString releaseBytes = ByteString.copyFromUtf8(Build.VERSION.RELEASE);
        ByteString codeNameBytes = ByteString.copyFromUtf8(Build.VERSION.CODENAME);
        cos.writeTag(8, 2);
        cos.writeRawVarint32(this.getSessionOSSize(releaseBytes, codeNameBytes, isRooted));
        cos.writeEnum(1, 3);
        cos.writeBytes(2, releaseBytes);
        cos.writeBytes(3, codeNameBytes);
        cos.writeBool(4, isRooted);
    }

    public void writeSessionDevice(CodedOutputStream cos, String clsDeviceId, int arch, String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, Map<IdManager.DeviceIdentifierType, String> ids, int state, String manufacturer, String modelClass) throws Exception {
        ByteString clsDeviceIDBytes = ByteString.copyFromUtf8(clsDeviceId);
        ByteString modelBytes = this.stringToByteString(model);
        ByteString modelClassBytes = this.stringToByteString(modelClass);
        ByteString manufacturerBytes = this.stringToByteString(manufacturer);
        cos.writeTag(9, 2);
        cos.writeRawVarint32(this.getSessionDeviceSize(arch, clsDeviceIDBytes, modelBytes, availableProcessors, totalRam, diskSpace, isEmulator, ids, state, manufacturerBytes, modelClassBytes));
        cos.writeBytes(1, clsDeviceIDBytes);
        cos.writeEnum(3, arch);
        cos.writeBytes(4, modelBytes);
        cos.writeUInt32(5, availableProcessors);
        cos.writeUInt64(6, totalRam);
        cos.writeUInt64(7, diskSpace);
        cos.writeBool(10, isEmulator);
        for (Map.Entry<IdManager.DeviceIdentifierType, String> id2 : ids.entrySet()) {
            cos.writeTag(11, 2);
            cos.writeRawVarint32(this.getDeviceIdentifierSize(id2.getKey(), id2.getValue()));
            cos.writeEnum(1, id2.getKey().protobufIndex);
            cos.writeBytes(2, ByteString.copyFromUtf8(id2.getValue()));
        }
        cos.writeUInt32(12, state);
        if (manufacturerBytes != null) {
            cos.writeBytes(13, manufacturerBytes);
        }
        if (modelClassBytes != null) {
            cos.writeBytes(14, modelClassBytes);
        }
    }

    public void writeSessionUser(CodedOutputStream cos, String id2, String name, String email) throws Exception {
        ByteString idBytes = ByteString.copyFromUtf8(id2 == null ? "" : id2);
        ByteString nameBytes = this.stringToByteString(name);
        ByteString emailBytes = this.stringToByteString(email);
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, idBytes);
        if (name != null) {
            size += CodedOutputStream.computeBytesSize(2, nameBytes);
        }
        if (email != null) {
            size += CodedOutputStream.computeBytesSize(3, emailBytes);
        }
        cos.writeTag(6, 2);
        cos.writeRawVarint32(size);
        cos.writeBytes(1, idBytes);
        if (name != null) {
            cos.writeBytes(2, nameBytes);
        }
        if (email != null) {
            cos.writeBytes(3, emailBytes);
        }
    }

    public void writeSessionEvent(CodedOutputStream cos, long eventTime, Thread thread, Throwable ex, String eventType, Thread[] threads, float batteryLevel, int batteryVelocity, boolean proximityEnabled, int orientation, long usedRamBytes, long diskUsedBytes, ActivityManager.RunningAppProcessInfo runningAppProcessInfo, List<StackTraceElement[]> stacks, StackTraceElement[] exceptionStack, LogFileManager logFileManager, Map<String, String> attributes) throws Exception {
        this.runningAppProcessInfo = runningAppProcessInfo;
        this.stacks = stacks;
        this.exceptionStack = exceptionStack;
        this.threads = threads;
        ByteString logByteString = logFileManager.getByteStringForLog();
        if (logByteString == null) {
            Fabric.getLogger().d("Fabric", "No log data to include with this event.");
        }
        logFileManager.closeLogFile();
        cos.writeTag(10, 2);
        cos.writeRawVarint32(this.getSessionEventSize(thread, ex, eventType, eventTime, attributes, batteryLevel, batteryVelocity, proximityEnabled, orientation, usedRamBytes, diskUsedBytes, logByteString));
        cos.writeUInt64(1, eventTime);
        cos.writeBytes(2, ByteString.copyFromUtf8(eventType));
        this.writeSessionEventApp(cos, thread, ex, orientation, attributes);
        this.writeSessionEventDevice(cos, batteryLevel, batteryVelocity, proximityEnabled, orientation, usedRamBytes, diskUsedBytes);
        this.writeSessionEventLog(cos, logByteString);
    }

    private void writeSessionEventApp(CodedOutputStream cos, Thread thread, Throwable ex, int orientation, Map<String, String> customAttributes) throws Exception {
        cos.writeTag(3, 2);
        cos.writeRawVarint32(this.getEventAppSize(thread, ex, orientation, customAttributes));
        this.writeSessionEventAppExecution(cos, thread, ex);
        if (customAttributes != null && !customAttributes.isEmpty()) {
            this.writeSessionEventAppCustomAttributes(cos, customAttributes);
        }
        if (this.runningAppProcessInfo != null) {
            cos.writeBool(3, this.runningAppProcessInfo.importance != 100);
        }
        cos.writeUInt32(4, orientation);
    }

    private void writeSessionEventAppExecution(CodedOutputStream cos, Thread exceptionThread, Throwable ex) throws Exception {
        cos.writeTag(1, 2);
        cos.writeRawVarint32(this.getEventAppExecutionSize(exceptionThread, ex));
        this.writeThread(cos, exceptionThread, this.exceptionStack, 4, true);
        int len = this.threads.length;
        for (int i = 0; i < len; ++i) {
            Thread thread = this.threads[i];
            this.writeThread(cos, thread, this.stacks.get(i), 0, false);
        }
        this.writeSessionEventAppExecutionException(cos, ex, 1, 2);
        cos.writeTag(3, 2);
        cos.writeRawVarint32(this.getEventAppExecutionSignalSize());
        cos.writeBytes(1, SIGNAL_DEFAULT_BYTE_STRING);
        cos.writeBytes(2, SIGNAL_DEFAULT_BYTE_STRING);
        cos.writeUInt64(3, 0L);
        cos.writeTag(4, 2);
        cos.writeRawVarint32(this.getBinaryImageSize());
        cos.writeUInt64(1, 0L);
        cos.writeUInt64(2, 0L);
        cos.writeBytes(3, this.packageNameBytes);
        if (this.optionalBuildIdBytes != null) {
            cos.writeBytes(4, this.optionalBuildIdBytes);
        }
    }

    private void writeSessionEventAppCustomAttributes(CodedOutputStream cos, Map<String, String> customAttributes) throws Exception {
        for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
            cos.writeTag(2, 2);
            cos.writeRawVarint32(this.getEventAppCustomAttributeSize(entry.getKey(), entry.getValue()));
            cos.writeBytes(1, ByteString.copyFromUtf8(entry.getKey()));
            String value = entry.getValue();
            cos.writeBytes(2, ByteString.copyFromUtf8(value == null ? "" : value));
        }
    }

    private void writeSessionEventAppExecutionException(CodedOutputStream cos, Throwable ex, int chainDepth, int field) throws Exception {
        cos.writeTag(field, 2);
        cos.writeRawVarint32(this.getEventAppExecutionExceptionSize(ex, 1));
        cos.writeBytes(1, ByteString.copyFromUtf8(ex.getClass().getName()));
        String message = ex.getLocalizedMessage();
        if (message != null) {
            cos.writeBytes(3, ByteString.copyFromUtf8(message));
        }
        for (StackTraceElement element : ex.getStackTrace()) {
            this.writeFrame(cos, 4, element, true);
        }
        Throwable cause = ex.getCause();
        if (cause != null) {
            if (chainDepth < this.maxChainedExceptionsDepth) {
                this.writeSessionEventAppExecutionException(cos, cause, chainDepth + 1, 6);
            } else {
                int overflowCount = 0;
                while (cause != null) {
                    cause = cause.getCause();
                    ++overflowCount;
                }
                cos.writeUInt32(7, overflowCount);
            }
        }
    }

    private void writeThread(CodedOutputStream cos, Thread thread, StackTraceElement[] stackTraceElements, int importance, boolean isCrashedThread) throws Exception {
        cos.writeTag(1, 2);
        int s = this.getThreadSize(thread, stackTraceElements, importance, isCrashedThread);
        cos.writeRawVarint32(s);
        cos.writeBytes(1, ByteString.copyFromUtf8(thread.getName()));
        cos.writeUInt32(2, importance);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            this.writeFrame(cos, 3, stackTraceElement, isCrashedThread);
        }
    }

    private void writeFrame(CodedOutputStream cos, int fieldIndex, StackTraceElement element, boolean isCrashedThread) throws Exception {
        cos.writeTag(fieldIndex, 2);
        cos.writeRawVarint32(this.getFrameSize(element, isCrashedThread));
        if (element.isNativeMethod()) {
            cos.writeUInt64(1, Math.max(element.getLineNumber(), 0));
        } else {
            cos.writeUInt64(1, 0L);
        }
        cos.writeBytes(2, ByteString.copyFromUtf8(element.getClassName() + "." + element.getMethodName()));
        if (element.getFileName() != null) {
            cos.writeBytes(3, ByteString.copyFromUtf8(element.getFileName()));
        }
        if (!element.isNativeMethod() && element.getLineNumber() > 0) {
            cos.writeUInt64(4, element.getLineNumber());
        }
        cos.writeUInt32(5, isCrashedThread ? 4 : 0);
    }

    private void writeSessionEventDevice(CodedOutputStream cos, float batteryLevel, int batterVelocity, boolean proximityEnabled, int orientation, long heapAllocatedSize, long diskUsed) throws Exception {
        cos.writeTag(5, 2);
        cos.writeRawVarint32(this.getEventDeviceSize(batteryLevel, batterVelocity, proximityEnabled, orientation, heapAllocatedSize, diskUsed));
        cos.writeFloat(1, batteryLevel);
        cos.writeSInt32(2, batterVelocity);
        cos.writeBool(3, proximityEnabled);
        cos.writeUInt32(4, orientation);
        cos.writeUInt64(5, heapAllocatedSize);
        cos.writeUInt64(6, diskUsed);
    }

    private void writeSessionEventLog(CodedOutputStream cos, ByteString log) throws Exception {
        if (log != null) {
            cos.writeTag(6, 2);
            cos.writeRawVarint32(this.getEventLogSize(log));
            cos.writeBytes(1, log);
        }
    }

    private int getSessionAppSize(ByteString packageName, ByteString versionCode, ByteString versionName, ByteString installUuid, int deliveryMechanism) {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, packageName);
        size += CodedOutputStream.computeBytesSize(2, versionCode);
        size += CodedOutputStream.computeBytesSize(3, versionName);
        int orgSize = this.getSessionAppOrgSize();
        size += CodedOutputStream.computeTagSize(5) + CodedOutputStream.computeRawVarint32Size(orgSize) + orgSize;
        size += CodedOutputStream.computeBytesSize(6, installUuid);
        return size += CodedOutputStream.computeEnumSize(10, deliveryMechanism);
    }

    private int getSessionAppOrgSize() {
        int size = 0;
        return size += CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(new ApiKey().getValue(this.context)));
    }

    private int getSessionOSSize(ByteString release, ByteString codeName, boolean isRooted) {
        int size = 0;
        size += CodedOutputStream.computeEnumSize(1, 3);
        size += CodedOutputStream.computeBytesSize(2, release);
        size += CodedOutputStream.computeBytesSize(3, codeName);
        return size += CodedOutputStream.computeBoolSize(4, isRooted);
    }

    private int getDeviceIdentifierSize(IdManager.DeviceIdentifierType type, String value) {
        int size = CodedOutputStream.computeEnumSize(1, type.protobufIndex);
        return size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(value));
    }

    private int getSessionDeviceSize(int arch, ByteString clsDeviceID, ByteString model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, Map<IdManager.DeviceIdentifierType, String> ids, int state, ByteString manufacturer, ByteString modelClass) {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, clsDeviceID);
        size += CodedOutputStream.computeEnumSize(3, arch);
        size += model == null ? 0 : CodedOutputStream.computeBytesSize(4, model);
        size += CodedOutputStream.computeUInt32Size(5, availableProcessors);
        size += CodedOutputStream.computeUInt64Size(6, totalRam);
        size += CodedOutputStream.computeUInt64Size(7, diskSpace);
        size += CodedOutputStream.computeBoolSize(10, isEmulator);
        if (ids != null) {
            for (Map.Entry<IdManager.DeviceIdentifierType, String> id2 : ids.entrySet()) {
                int idSize = this.getDeviceIdentifierSize(id2.getKey(), id2.getValue());
                size += CodedOutputStream.computeTagSize(11) + CodedOutputStream.computeRawVarint32Size(idSize) + idSize;
            }
        }
        size += CodedOutputStream.computeUInt32Size(12, state);
        size += manufacturer == null ? 0 : CodedOutputStream.computeBytesSize(13, manufacturer);
        return size += modelClass == null ? 0 : CodedOutputStream.computeBytesSize(14, modelClass);
    }

    private int getBinaryImageSize() {
        int size = 0;
        size += CodedOutputStream.computeUInt64Size(1, 0L);
        size += CodedOutputStream.computeUInt64Size(2, 0L);
        size += CodedOutputStream.computeBytesSize(3, this.packageNameBytes);
        if (this.optionalBuildIdBytes != null) {
            size += CodedOutputStream.computeBytesSize(4, this.optionalBuildIdBytes);
        }
        return size;
    }

    private int getSessionEventSize(Thread thread, Throwable ex, String eventType, long eventTime, Map<String, String> custAttrs, float batteryLevel, int batterVelocity, boolean proximityEnabled, int orientation, long heapAllocatedSize, long diskUsed, ByteString log) {
        int size = 0;
        size += CodedOutputStream.computeUInt64Size(1, eventTime);
        size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(eventType));
        int eventAppSize = this.getEventAppSize(thread, ex, orientation, custAttrs);
        size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(eventAppSize) + eventAppSize;
        int eventDeviceSize = this.getEventDeviceSize(batteryLevel, batterVelocity, proximityEnabled, orientation, heapAllocatedSize, diskUsed);
        size += CodedOutputStream.computeTagSize(5) + CodedOutputStream.computeRawVarint32Size(eventDeviceSize) + eventDeviceSize;
        if (log != null) {
            int logSize = this.getEventLogSize(log);
            size += CodedOutputStream.computeTagSize(6) + CodedOutputStream.computeRawVarint32Size(logSize) + logSize;
        }
        return size;
    }

    private int getEventAppSize(Thread thread, Throwable ex, int orientation, Map<String, String> customAttributes) {
        int size = 0;
        int executionSize = this.getEventAppExecutionSize(thread, ex);
        size += CodedOutputStream.computeTagSize(1) + CodedOutputStream.computeRawVarint32Size(executionSize) + executionSize;
        if (customAttributes != null) {
            for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                int entrySize = this.getEventAppCustomAttributeSize(entry.getKey(), entry.getValue());
                size += CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeRawVarint32Size(entrySize) + entrySize;
            }
        }
        if (this.runningAppProcessInfo != null) {
            size += CodedOutputStream.computeBoolSize(3, this.runningAppProcessInfo.importance != 100);
        }
        return size += CodedOutputStream.computeUInt32Size(4, orientation);
    }

    private int getEventAppExecutionSize(Thread exceptionThread, Throwable ex) {
        int size = 0;
        int threadSize = this.getThreadSize(exceptionThread, this.exceptionStack, 4, true);
        size += CodedOutputStream.computeTagSize(1) + CodedOutputStream.computeRawVarint32Size(threadSize) + threadSize;
        int len = this.threads.length;
        for (int i = 0; i < len; ++i) {
            Thread thread = this.threads[i];
            threadSize = this.getThreadSize(thread, this.stacks.get(i), 0, false);
            size += CodedOutputStream.computeTagSize(1) + CodedOutputStream.computeRawVarint32Size(threadSize) + threadSize;
        }
        int exceptionSize = this.getEventAppExecutionExceptionSize(ex, 1);
        size += CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeRawVarint32Size(exceptionSize) + exceptionSize;
        int signalSize = this.getEventAppExecutionSignalSize();
        size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(signalSize) + signalSize;
        int binaryImageSize = this.getBinaryImageSize();
        return size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(binaryImageSize) + binaryImageSize;
    }

    private int getEventAppCustomAttributeSize(String key, String value) {
        int size = CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(key));
        return size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(value == null ? "" : value));
    }

    private int getEventDeviceSize(float batteryLevel, int batterVelocity, boolean proximityEnabled, int orientation, long heapAllocatedSize, long diskUsed) {
        int size = 0;
        size += CodedOutputStream.computeFloatSize(1, batteryLevel);
        size += CodedOutputStream.computeSInt32Size(2, batterVelocity);
        size += CodedOutputStream.computeBoolSize(3, proximityEnabled);
        size += CodedOutputStream.computeUInt32Size(4, orientation);
        size += CodedOutputStream.computeUInt64Size(5, heapAllocatedSize);
        return size += CodedOutputStream.computeUInt64Size(6, diskUsed);
    }

    private int getEventLogSize(ByteString log) {
        return CodedOutputStream.computeBytesSize(1, log);
    }

    private int getEventAppExecutionExceptionSize(Throwable ex, int chainDepth) {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(ex.getClass().getName()));
        String message = ex.getLocalizedMessage();
        if (message != null) {
            size += CodedOutputStream.computeBytesSize(3, ByteString.copyFromUtf8(message));
        }
        for (StackTraceElement element : ex.getStackTrace()) {
            int frameSize = this.getFrameSize(element, true);
            size += CodedOutputStream.computeTagSize(4) + CodedOutputStream.computeRawVarint32Size(frameSize) + frameSize;
        }
        Throwable cause = ex.getCause();
        if (cause != null) {
            if (chainDepth < this.maxChainedExceptionsDepth) {
                int exceptionSize = this.getEventAppExecutionExceptionSize(cause, chainDepth + 1);
                size += CodedOutputStream.computeTagSize(6) + CodedOutputStream.computeRawVarint32Size(exceptionSize) + exceptionSize;
            } else {
                int overflowCount = 0;
                while (cause != null) {
                    cause = cause.getCause();
                    ++overflowCount;
                }
                size += CodedOutputStream.computeUInt32Size(7, overflowCount);
            }
        }
        return size;
    }

    private int getEventAppExecutionSignalSize() {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, SIGNAL_DEFAULT_BYTE_STRING);
        size += CodedOutputStream.computeBytesSize(2, SIGNAL_DEFAULT_BYTE_STRING);
        return size += CodedOutputStream.computeUInt64Size(3, 0L);
    }

    private int getFrameSize(StackTraceElement element, boolean isCrashedThread) {
        int size = 0;
        size = element.isNativeMethod() ? (size += CodedOutputStream.computeUInt64Size(1, Math.max(element.getLineNumber(), 0))) : (size += CodedOutputStream.computeUInt64Size(1, 0L));
        size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(element.getClassName() + "." + element.getMethodName()));
        if (element.getFileName() != null) {
            size += CodedOutputStream.computeBytesSize(3, ByteString.copyFromUtf8(element.getFileName()));
        }
        if (!element.isNativeMethod() && element.getLineNumber() > 0) {
            size += CodedOutputStream.computeUInt64Size(4, element.getLineNumber());
        }
        return size += CodedOutputStream.computeUInt32Size(5, isCrashedThread ? 2 : 0);
    }

    private int getThreadSize(Thread thread, StackTraceElement[] stackTraceElements, int importance, boolean isCrashedThread) {
        int size = CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(thread.getName()));
        size += CodedOutputStream.computeUInt32Size(2, importance);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            int frameSize = this.getFrameSize(stackTraceElement, isCrashedThread);
            size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(frameSize) + frameSize;
        }
        return size;
    }

    private ByteString stringToByteString(String s) {
        return s == null ? null : ByteString.copyFromUtf8(s);
    }
}

