/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.crashlytics.android.answers.AutoSessionAnalyticsManager;
import com.crashlytics.android.answers.EventAttributes;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsManager;
import com.crashlytics.android.answers.SessionEventMetadata;
import com.crashlytics.android.answers.SessionEventTransform;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.Crash;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.common.SystemCurrentTimeProvider;
import io.fabric.sdk.android.services.events.GZIPQueueFileEventStorage;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.FileStoreImpl;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.File;
import java.util.Map;
import java.util.UUID;

public class Answers
extends Kit<Boolean> {
    private String versionCode;
    private String versionName;
    private PreferenceStore preferenceStore;
    private long installedAt;
    SessionAnalyticsManager sessionAnalyticsManager;

    public static Answers getInstance() {
        return Fabric.getKit(Answers.class);
    }

    public void logEvent(String eventName, EventAttributes attributes) {
        if (eventName == null) {
            throw new NullPointerException("eventName must not be null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes must not be null");
        }
        if (this.sessionAnalyticsManager != null) {
            this.sessionAnalyticsManager.onCustom(eventName, attributes.attributes);
        }
    }

    public void onException(Crash.LoggedException exception) {
        if (this.sessionAnalyticsManager != null) {
            this.sessionAnalyticsManager.onError(exception.getSessionId());
        }
    }

    public void onException(Crash.FatalException exception) {
        if (this.sessionAnalyticsManager != null) {
            this.sessionAnalyticsManager.onCrash(exception.getSessionId());
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected boolean onPreExecute() {
        try {
            this.preferenceStore = new PreferenceStoreImpl(this);
            Context context = this.getContext();
            PackageManager packageManager = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            this.versionCode = Integer.toString(packageInfo.versionCode);
            String string2 = this.versionName = packageInfo.versionName == null ? "0.0" : packageInfo.versionName;
            if (Build.VERSION.SDK_INT >= 9) {
                this.installedAt = packageInfo.firstInstallTime;
            } else {
                ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
                this.installedAt = new File(appInfo.sourceDir).lastModified();
            }
            return true;
        }
        catch (Exception e) {
            Fabric.getLogger().e("Answers", "Error setting up app properties", e);
            return false;
        }
    }

    @Override
    protected Boolean doInBackground() {
        Context context = this.getContext();
        this.initializeSessionAnalytics(context);
        try {
            SettingsData settingsData = Settings.getInstance().awaitSettingsData();
            if (settingsData == null) {
                return false;
            }
            if (settingsData.featuresData.collectAnalytics) {
                this.sessionAnalyticsManager.setAnalyticsSettingsData(settingsData.analyticsSettingsData, this.getOverridenSpiEndpoint());
                return true;
            }
            CommonUtils.logControlled(context, "Disabling analytics collection based on settings flag value.");
            this.sessionAnalyticsManager.disable();
            return false;
        }
        catch (Exception e) {
            Fabric.getLogger().e("Answers", "Error dealing with settings", e);
            return false;
        }
    }

    @Override
    public String getIdentifier() {
        return "com.crashlytics.sdk.android:answers";
    }

    @Override
    public String getVersion() {
        return "1.2.0.42";
    }

    @SuppressLint(value={"CommitPrefEdits"})
    @TargetApi(value=14)
    private void initializeSessionAnalytics(Context context) {
        try {
            SessionEventTransform transform = new SessionEventTransform();
            SystemCurrentTimeProvider timeProvider = new SystemCurrentTimeProvider();
            GZIPQueueFileEventStorage storage = new GZIPQueueFileEventStorage(this.getContext(), this.getSdkDirectory(), "session_analytics.tap", "session_analytics_to_send");
            SessionAnalyticsFilesManager analyticsFilesManager = new SessionAnalyticsFilesManager(context, transform, timeProvider, storage);
            IdManager idManager = this.getIdManager();
            Map<IdManager.DeviceIdentifierType, String> deviceIdentifiers = idManager.getDeviceIdentifiers();
            String appBundleId = context.getPackageName();
            String installationId = idManager.getAppInstallIdentifier();
            String androidId = deviceIdentifiers.get((Object)IdManager.DeviceIdentifierType.ANDROID_ID);
            String advertisingId = deviceIdentifiers.get((Object)IdManager.DeviceIdentifierType.ANDROID_ADVERTISING_ID);
            String betaDeviceToken = deviceIdentifiers.get((Object)IdManager.DeviceIdentifierType.FONT_TOKEN);
            String buildId = CommonUtils.resolveBuildId(context);
            String osVersion = idManager.getOsVersionString();
            String deviceModel = idManager.getModelName();
            String executionId = UUID.randomUUID().toString();
            SessionEventMetadata sessionEventMetadata = new SessionEventMetadata(appBundleId, executionId, installationId, androidId, advertisingId, betaDeviceToken, buildId, osVersion, deviceModel, this.versionCode, this.versionName);
            Application application = (Application)this.getContext().getApplicationContext();
            this.sessionAnalyticsManager = application != null && Build.VERSION.SDK_INT >= 14 ? AutoSessionAnalyticsManager.build(application, sessionEventMetadata, analyticsFilesManager, (HttpRequestFactory)new DefaultHttpRequestFactory(Fabric.getLogger())) : SessionAnalyticsManager.build(context, sessionEventMetadata, analyticsFilesManager, new DefaultHttpRequestFactory(Fabric.getLogger()));
            if (this.isFirstLaunch(this.installedAt)) {
                Fabric.getLogger().d("Answers", "First launch");
                this.sessionAnalyticsManager.onInstall();
                this.preferenceStore.save(this.preferenceStore.edit().putBoolean("analytics_launched", true));
            }
        }
        catch (Exception e) {
            CommonUtils.logControlledError(context, "Crashlytics failed to initialize session analytics.", e);
        }
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue(this.getContext(), "com.crashlytics.ApiEndpoint");
    }

    boolean getAnalyticsLaunched() {
        return this.preferenceStore.get().getBoolean("analytics_launched", false);
    }

    boolean isFirstLaunch(long installedAt) {
        return !this.getAnalyticsLaunched() && this.installedRecently(installedAt);
    }

    boolean installedRecently(long installedAt) {
        long timeDifferenceInMilliseconds = System.currentTimeMillis() - installedAt;
        return timeDifferenceInMilliseconds < 3600000L;
    }

    File getSdkDirectory() {
        return new FileStoreImpl(this).getFilesDir();
    }
}

