/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import com.crashlytics.android.answers.RandomBackoff;
import com.crashlytics.android.answers.RetryManager;
import com.crashlytics.android.answers.SessionAnalyticsFilesSender;
import io.fabric.sdk.android.services.concurrency.internal.DefaultRetryPolicy;
import io.fabric.sdk.android.services.concurrency.internal.ExponentialBackoff;
import io.fabric.sdk.android.services.concurrency.internal.RetryState;
import io.fabric.sdk.android.services.events.FilesSender;
import java.io.File;
import java.util.List;

class AnswersRetryFilesSender
implements FilesSender {
    private final SessionAnalyticsFilesSender filesSender;
    private final RetryManager retryManager;

    public static AnswersRetryFilesSender build(SessionAnalyticsFilesSender filesSender) {
        RandomBackoff backoff = new RandomBackoff(new ExponentialBackoff(1000L, 8), 0.1);
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(5);
        RetryState retryState = new RetryState(backoff, retryPolicy);
        RetryManager retryManager = new RetryManager(retryState);
        return new AnswersRetryFilesSender(filesSender, retryManager);
    }

    AnswersRetryFilesSender(SessionAnalyticsFilesSender filesSender, RetryManager retryManager) {
        this.filesSender = filesSender;
        this.retryManager = retryManager;
    }

    @Override
    public boolean send(List<File> files) {
        long currentNanoTime = System.nanoTime();
        if (this.retryManager.canRetry(currentNanoTime)) {
            boolean cleanup = this.filesSender.send(files);
            if (cleanup) {
                this.retryManager.reset();
                return true;
            }
            this.retryManager.recordRetry(currentNanoTime);
            return false;
        }
        return false;
    }
}

