/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import io.fabric.sdk.android.services.concurrency.internal.Backoff;
import java.util.Random;

class RandomBackoff
implements Backoff {
    final Backoff backoff;
    final Random random;
    final double jitterPercent;

    public RandomBackoff(Backoff backoff, double jitterPercent) {
        this(backoff, jitterPercent, new Random());
    }

    public RandomBackoff(Backoff backoff, double jitterPercent, Random random) {
        if (jitterPercent < 0.0 || jitterPercent > 1.0) {
            throw new IllegalArgumentException("jitterPercent must be between 0.0 and 1.0");
        }
        if (backoff == null) {
            throw new NullPointerException("backoff must not be null");
        }
        if (random == null) {
            throw new NullPointerException("random must not be null");
        }
        this.backoff = backoff;
        this.jitterPercent = jitterPercent;
        this.random = random;
    }

    @Override
    public long getDelayMillis(int retries) {
        return (long)(this.randomJitter() * (double)this.backoff.getDelayMillis(retries));
    }

    double randomJitter() {
        double minJitter = 1.0 - this.jitterPercent;
        double maxJitter = 1.0 + this.jitterPercent;
        double randomDouble = this.random.nextDouble();
        return minJitter + (maxJitter - minJitter) * randomDouble;
    }
}

