/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.annotation.TargetApi;
import android.os.Build;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import io.fabric.sdk.android.services.events.EventTransform;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

class SessionEventTransform
implements EventTransform<SessionEvent> {
    SessionEventTransform() {
    }

    @Override
    public byte[] toBytes(SessionEvent event) throws IOException {
        return this.buildJsonForEvent(event).toString().getBytes("UTF-8");
    }

    @TargetApi(value=9)
    public JSONObject buildJsonForEvent(SessionEvent event) throws IOException {
        try {
            JSONObject jsonObject = new JSONObject();
            SessionEventMetadata sessionEventMetadata = event.sessionEventMetadata;
            jsonObject.put("appBundleId", (Object)sessionEventMetadata.appBundleId);
            jsonObject.put("executionId", (Object)sessionEventMetadata.executionId);
            jsonObject.put("installationId", (Object)sessionEventMetadata.installationId);
            jsonObject.put("androidId", (Object)sessionEventMetadata.androidId);
            jsonObject.put("advertisingId", (Object)sessionEventMetadata.advertisingId);
            jsonObject.put("betaDeviceToken", (Object)sessionEventMetadata.betaDeviceToken);
            jsonObject.put("buildId", (Object)sessionEventMetadata.buildId);
            jsonObject.put("osVersion", (Object)sessionEventMetadata.osVersion);
            jsonObject.put("deviceModel", (Object)sessionEventMetadata.deviceModel);
            jsonObject.put("appVersionCode", (Object)sessionEventMetadata.appVersionCode);
            jsonObject.put("appVersionName", (Object)sessionEventMetadata.appVersionName);
            jsonObject.put("timestamp", event.timestamp);
            jsonObject.put("type", (Object)event.type.toString());
            jsonObject.put("details", (Object)new JSONObject(event.details));
            jsonObject.put("customType", (Object)event.customType);
            jsonObject.put("customAttributes", (Object)new JSONObject(event.customAttributes));
            return jsonObject;
        }
        catch (JSONException e) {
            if (Build.VERSION.SDK_INT >= 9) {
                throw new IOException(e.getMessage(), e);
            }
            throw new IOException(e.getMessage());
        }
    }
}

