/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.crashlytics.android.beta.BuildProperties;
import com.crashlytics.android.beta.CheckForUpdatesController;
import com.crashlytics.android.beta.DeviceTokenLoader;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.cache.MemoryValueCache;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeviceIdentifierProvider;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.common.SystemCurrentTimeProvider;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.BetaSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Beta
extends Kit<Boolean>
implements DeviceIdentifierProvider {
    private final MemoryValueCache<String> deviceTokenCache = new MemoryValueCache();
    private final DeviceTokenLoader deviceTokenLoader = new DeviceTokenLoader();

    @Override
    protected Boolean doInBackground() {
        Fabric.getLogger().d("Beta", "Beta kit initializing...");
        Context context = this.getContext();
        IdManager idManager = this.getIdManager();
        String installerPackageName = idManager.getInstallerPackageName();
        String betaDeviceToken = this.getBetaDeviceToken(context, installerPackageName);
        if (TextUtils.isEmpty((CharSequence)betaDeviceToken)) {
            Fabric.getLogger().d("Beta", "A Beta device token was not found for this app");
            return false;
        }
        Fabric.getLogger().d("Beta", "Beta device token is present, checking for app updates.");
        BetaSettingsData betaSettings = this.getBetaSettingsData();
        BuildProperties buildProps = this.loadBuildProperties(context);
        if (this.canCheckForUpdates(betaSettings, buildProps)) {
            this.checkForUpdates(context, idManager, betaSettings, buildProps);
        }
        return true;
    }

    @Override
    public Map<IdManager.DeviceIdentifierType, String> getDeviceIdentifiers() {
        String installerPackageName = this.getIdManager().getInstallerPackageName();
        String betaDeviceToken = this.getBetaDeviceToken(this.getContext(), installerPackageName);
        HashMap<IdManager.DeviceIdentifierType, String> ids = new HashMap<IdManager.DeviceIdentifierType, String>();
        if (!TextUtils.isEmpty((CharSequence)betaDeviceToken)) {
            ids.put(IdManager.DeviceIdentifierType.FONT_TOKEN, betaDeviceToken);
        }
        return ids;
    }

    @Override
    public String getIdentifier() {
        return "com.crashlytics.sdk.android:beta";
    }

    @Override
    public String getVersion() {
        return "1.1.2.37";
    }

    private void checkForUpdates(Context context, IdManager idManager, BetaSettingsData betaSettings, BuildProperties buildProps) {
        new CheckForUpdatesController(context, this, idManager, betaSettings, buildProps, new PreferenceStoreImpl(Fabric.getKit(Beta.class)), new SystemCurrentTimeProvider(), new DefaultHttpRequestFactory(Fabric.getLogger())).checkForUpdates();
    }

    @TargetApi(value=11)
    boolean isAppPossiblyInstalledByBeta(String installerPackageName, int apiLevel) {
        if (apiLevel < 11) {
            return installerPackageName == null;
        }
        return "io.crash.air".equals(installerPackageName);
    }

    boolean canCheckForUpdates(BetaSettingsData betaSettings, BuildProperties buildProps) {
        return betaSettings != null && !TextUtils.isEmpty((CharSequence)betaSettings.updateUrl) && buildProps != null;
    }

    private String getBetaDeviceToken(Context context, String installerPackageName) {
        String token = null;
        if (this.isAppPossiblyInstalledByBeta(installerPackageName, Build.VERSION.SDK_INT)) {
            Fabric.getLogger().d("Beta", "App was installed by Beta. Getting device token");
            try {
                String cachedToken = this.deviceTokenCache.get(context, this.deviceTokenLoader);
                token = "".equals(cachedToken) ? null : cachedToken;
            }
            catch (Exception e) {
                Fabric.getLogger().e("Beta", "Failed to load the Beta device token", e);
            }
        } else {
            Fabric.getLogger().d("Beta", "App was not installed by Beta. Skipping device token");
        }
        return token;
    }

    private BetaSettingsData getBetaSettingsData() {
        SettingsData settingsData = Settings.getInstance().awaitSettingsData();
        if (settingsData != null) {
            return settingsData.betaSettingsData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildProperties loadBuildProperties(Context context) {
        InputStream buildPropsStream = null;
        BuildProperties buildProps = null;
        try {
            buildPropsStream = context.getAssets().open("crashlytics-build.properties");
            if (buildPropsStream != null) {
                buildProps = BuildProperties.fromPropertiesStream(buildPropsStream);
                Fabric.getLogger().d("Beta", buildProps.packageName + " build properties: " + buildProps.versionName + " (" + buildProps.versionCode + ")" + " - " + buildProps.buildId);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Beta", "Error reading Beta build properties", e);
        }
        finally {
            if (buildPropsStream != null) {
                try {
                    buildPropsStream.close();
                }
                catch (IOException e) {
                    Fabric.getLogger().e("Beta", "Error closing Beta build properties asset", e);
                }
            }
        }
        return buildProps;
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue(this.getContext(), "com.crashlytics.ApiEndpoint");
    }
}

