/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import android.content.Context;
import com.crashlytics.android.beta.Beta;
import com.crashlytics.android.beta.BuildProperties;
import com.crashlytics.android.beta.CheckForUpdatesRequest;
import com.crashlytics.android.beta.CheckForUpdatesResponseTransform;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CurrentTimeProvider;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.settings.BetaSettingsData;

class CheckForUpdatesController {
    private final Context context;
    private final Beta beta;
    private final IdManager idManager;
    private final BetaSettingsData betaSettings;
    private final BuildProperties buildProps;
    private final PreferenceStore preferenceStore;
    private final CurrentTimeProvider currentTimeProvider;
    private final HttpRequestFactory httpRequestFactory;

    public CheckForUpdatesController(Context context, Beta beta, IdManager idManager, BetaSettingsData betaSettings, BuildProperties buildProps, PreferenceStore prefsStore, CurrentTimeProvider currentTimeProvider, HttpRequestFactory httpRequestFactory) {
        this.context = context;
        this.beta = beta;
        this.idManager = idManager;
        this.betaSettings = betaSettings;
        this.buildProps = buildProps;
        this.preferenceStore = prefsStore;
        this.currentTimeProvider = currentTimeProvider;
        this.httpRequestFactory = httpRequestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates() {
        long currentTimeMillis = this.currentTimeProvider.getCurrentTimeMillis();
        long updateCheckDelayMillis = this.betaSettings.updateSuspendDurationSeconds * 1000;
        Fabric.getLogger().d("Beta", "Check for updates delay: " + updateCheckDelayMillis);
        long lastCheckTimeMillis = this.preferenceStore.get().getLong("last_update_check", 0L);
        Fabric.getLogger().d("Beta", "Check for updates last check time: " + lastCheckTimeMillis);
        long nextCheckTimeMillis = lastCheckTimeMillis + updateCheckDelayMillis;
        Fabric.getLogger().d("Beta", "Check for updates current time: " + currentTimeMillis + ", next check time: " + nextCheckTimeMillis);
        if (currentTimeMillis >= nextCheckTimeMillis) {
            try {
                Fabric.getLogger().d("Beta", "Performing update check");
                String apiKey = new ApiKey().getValue(this.context);
                String idHeaderValue = this.idManager.createIdHeaderValue(apiKey, this.buildProps.packageName);
                CheckForUpdatesRequest request = new CheckForUpdatesRequest((Kit)this.beta, this.beta.getOverridenSpiEndpoint(), this.betaSettings.updateUrl, this.httpRequestFactory, new CheckForUpdatesResponseTransform());
                request.invoke(apiKey, idHeaderValue, this.buildProps);
            }
            finally {
                this.preferenceStore.edit().putLong("last_update_check", currentTimeMillis).commit();
            }
        } else {
            Fabric.getLogger().d("Beta", "Check for updates next check time was not passed");
        }
    }
}

