/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.cache.ValueLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DeviceTokenLoader
implements ValueLoader<String> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String load(Context context) throws Exception {
        long start = System.nanoTime();
        String token = "";
        ZipInputStream zis = null;
        try {
            zis = this.getZipInputStreamOfAppApkFrom(context);
            token = this.determineDeviceToken(zis);
        }
        catch (PackageManager.NameNotFoundException e) {
            Fabric.getLogger().e("Beta", "Failed to find this app in the PackageManager", e);
        }
        catch (FileNotFoundException e) {
            Fabric.getLogger().e("Beta", "Failed to find the APK file", e);
        }
        catch (IOException e) {
            Fabric.getLogger().e("Beta", "Failed to read the APK file", e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    Fabric.getLogger().e("Beta", "Failed to close the APK file", e);
                }
            }
        }
        long end = System.nanoTime();
        double millis = (double)(end - start) / 1000000.0;
        Fabric.getLogger().d("Beta", "Beta device token load took " + millis + "ms");
        return token;
    }

    ZipInputStream getZipInputStreamOfAppApkFrom(Context context) throws PackageManager.NameNotFoundException, FileNotFoundException {
        PackageManager pm = context.getPackageManager();
        ApplicationInfo info = pm.getApplicationInfo(context.getPackageName(), 0);
        return new ZipInputStream(new FileInputStream(info.sourceDir));
    }

    String determineDeviceToken(ZipInputStream zis) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            if (!name.startsWith("assets/com.crashlytics.android.beta/dirfactor-device-token=")) continue;
            return name.substring("assets/com.crashlytics.android.beta/dirfactor-device-token=".length(), name.length() - 1);
        }
        return "";
    }
}

