/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.bundle.MessageBundleBuilder;
import com.github.fge.msgsimple.locale.LocaleUtils;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;

public final class MessageBundle {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    public static MessageBundleBuilder newBuilder() {
        return new MessageBundleBuilder();
    }

    MessageBundle(MessageBundleBuilder builder) {
        this.providers.addAll(builder.providers);
    }

    public String getMessage(Locale locale, String key) {
        BUNDLE.checkNotNull(key, "query.nullKey");
        BUNDLE.checkNotNull(locale, "query.nullLocale");
        for (Locale l : LocaleUtils.getApplicable(locale)) {
            for (MessageSourceProvider provider : this.providers) {
                String ret;
                MessageSource source = provider.getMessageSource(l);
                if (source == null || (ret = source.getKey(key)) == null) continue;
                return ret;
            }
        }
        return key;
    }

    public String getMessage(String key) {
        return this.getMessage(Locale.getDefault(), key);
    }

    public String printf(Locale locale, String key, Object ... params) {
        String format = this.getMessage(locale, key);
        try {
            return String.format(locale, format, params);
        }
        catch (IllegalFormatException ignored) {
            return format;
        }
    }

    public String printf(String key, Object ... params) {
        return this.printf(Locale.getDefault(), key, params);
    }

    public <T> T checkNotNull(T reference, Locale locale, String key) {
        if (reference == null) {
            throw new NullPointerException(this.getMessage(locale, key));
        }
        return reference;
    }

    public <T> T checkNotNull(T reference, String key) {
        return this.checkNotNull(reference, Locale.getDefault(), key);
    }
}

