/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.specs;

import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.specs.VariableSpecType;

public final class PrefixVariable
extends VariableSpec {
    private final int length;

    public PrefixVariable(String name, int length) {
        super(VariableSpecType.PREFIX, name);
        this.length = length;
    }

    @Override
    public boolean isExploded() {
        return false;
    }

    @Override
    public int getPrefixLength() {
        return this.length;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.length;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixVariable other = (PrefixVariable)obj;
        return this.name.equals(other.name) && this.length == other.length;
    }

    public String toString() {
        return this.name + " (prefix length: " + this.length + ')';
    }
}

