/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.dashclock.api;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.URISyntaxException;

public class ExtensionData
implements Parcelable {
    private boolean mVisible = false;
    private int mIcon = 0;
    private Uri mIconUri = null;
    private String mStatus = null;
    private String mExpandedTitle = null;
    private String mExpandedBody = null;
    private Intent mClickIntent = null;
    private String mContentDescription = null;
    public static final Parcelable.Creator<ExtensionData> CREATOR = new Parcelable.Creator<ExtensionData>(){

        public ExtensionData createFromParcel(Parcel in) {
            return new ExtensionData(in);
        }

        public ExtensionData[] newArray(int size) {
            return new ExtensionData[size];
        }
    };

    public ExtensionData() {
    }

    public ExtensionData visible(boolean visible) {
        this.mVisible = visible;
        return this;
    }

    public ExtensionData icon(int icon) {
        this.mIcon = icon;
        return this;
    }

    public ExtensionData status(String status) {
        this.mStatus = status;
        return this;
    }

    public ExtensionData expandedTitle(String expandedTitle) {
        this.mExpandedTitle = expandedTitle;
        return this;
    }

    public ExtensionData expandedBody(String expandedBody) {
        this.mExpandedBody = expandedBody;
        return this;
    }

    public ExtensionData clickIntent(Intent clickIntent) {
        this.mClickIntent = clickIntent;
        return this;
    }

    private ExtensionData(Parcel in) {
        int parcelableVersion = in.readInt();
        int parcelableSize = in.readInt();
        int startPosition = in.dataPosition();
        if (parcelableVersion >= 1) {
            this.mVisible = in.readInt() != 0;
            this.mIcon = in.readInt();
            this.mStatus = in.readString();
            if (TextUtils.isEmpty((CharSequence)this.mStatus)) {
                this.mStatus = null;
            }
            this.mExpandedTitle = in.readString();
            if (TextUtils.isEmpty((CharSequence)this.mExpandedTitle)) {
                this.mExpandedTitle = null;
            }
            this.mExpandedBody = in.readString();
            if (TextUtils.isEmpty((CharSequence)this.mExpandedBody)) {
                this.mExpandedBody = null;
            }
            try {
                this.mClickIntent = Intent.parseUri((String)in.readString(), (int)0);
            }
            catch (URISyntaxException ignored) {
                // empty catch block
            }
        }
        if (parcelableVersion >= 2) {
            String iconUriString;
            this.mContentDescription = in.readString();
            if (TextUtils.isEmpty((CharSequence)this.mContentDescription)) {
                this.mContentDescription = null;
            }
            Uri uri = this.mIconUri = TextUtils.isEmpty((CharSequence)(iconUriString = in.readString())) ? null : Uri.parse((String)iconUriString);
        }
        if (parcelableVersion >= 2) {
            in.setDataPosition(startPosition + parcelableSize);
        }
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(2);
        int sizePosition = parcel.dataPosition();
        parcel.writeInt(0);
        int startPosition = parcel.dataPosition();
        parcel.writeInt(this.mVisible ? 1 : 0);
        parcel.writeInt(this.mIcon);
        parcel.writeString(TextUtils.isEmpty((CharSequence)this.mStatus) ? "" : this.mStatus);
        parcel.writeString(TextUtils.isEmpty((CharSequence)this.mExpandedTitle) ? "" : this.mExpandedTitle);
        parcel.writeString(TextUtils.isEmpty((CharSequence)this.mExpandedBody) ? "" : this.mExpandedBody);
        parcel.writeString(this.mClickIntent == null ? "" : this.mClickIntent.toUri(0));
        parcel.writeString(TextUtils.isEmpty((CharSequence)this.mContentDescription) ? "" : this.mContentDescription);
        parcel.writeString(this.mIconUri == null ? "" : this.mIconUri.toString());
        int parcelableSize = parcel.dataPosition() - startPosition;
        parcel.setDataPosition(sizePosition);
        parcel.writeInt(parcelableSize);
        parcel.setDataPosition(startPosition + parcelableSize);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            ExtensionData other = (ExtensionData)o;
            return other.mVisible == this.mVisible && other.mIcon == this.mIcon && ExtensionData.objectEquals(other.mIconUri, this.mIconUri) && TextUtils.equals((CharSequence)other.mStatus, (CharSequence)this.mStatus) && TextUtils.equals((CharSequence)other.mExpandedTitle, (CharSequence)this.mExpandedTitle) && TextUtils.equals((CharSequence)other.mExpandedBody, (CharSequence)this.mExpandedBody) && ExtensionData.objectEquals(other.mClickIntent, this.mClickIntent) && TextUtils.equals((CharSequence)other.mContentDescription, (CharSequence)this.mContentDescription);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean objectEquals(Object x, Object y) {
        if (x == null || y == null) {
            return x == y;
        }
        return x.equals(y);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

