/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.dashclock.api.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.apps.dashclock.api.ExtensionData;

public interface IExtensionHost
extends IInterface {
    public void publishUpdate(ExtensionData var1) throws RemoteException;

    public void addWatchContentUris(String[] var1) throws RemoteException;

    public void setUpdateWhenScreenOn(boolean var1) throws RemoteException;

    public void removeAllWatchContentUris() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IExtensionHost {
        public static IExtensionHost asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("com.google.android.apps.dashclock.api.internal.IExtensionHost");
            if (iin != null && iin instanceof IExtensionHost) {
                return (IExtensionHost)iin;
            }
            return new Proxy(obj);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    ExtensionData _arg0 = 0 != data.readInt() ? (ExtensionData)ExtensionData.CREATOR.createFromParcel(data) : null;
                    this.publishUpdate(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    String[] _arg0 = data.createStringArray();
                    this.addWatchContentUris(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    boolean _arg0 = 0 != data.readInt();
                    this.setUpdateWhenScreenOn(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    this.removeAllWatchContentUris();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IExtensionHost {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publishUpdate(ExtensionData data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWatchContentUris(String[] contentUris) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    _data.writeStringArray(contentUris);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUpdateWhenScreenOn(boolean updateWhenScreenOn) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    _data.writeInt(updateWhenScreenOn ? 1 : 0);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllWatchContentUris() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("com.google.android.apps.dashclock.api.internal.IExtensionHost");
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

