/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util.client;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzlk;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

@zzgd
public class zza {
    public static final Handler zzGF = new Handler(Looper.getMainLooper());

    public int zzb(Context context, int n) {
        return this.zza(context.getResources().getDisplayMetrics(), n);
    }

    public int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public int zzc(Context context, int n) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return this.zzb(displayMetrics, n);
    }

    public int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public boolean zzgw() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public String zzax(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string2.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        return null;
    }

    public boolean zzQ(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    public boolean zzR(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int n = 0;
        int n2 = 0;
        if (zzlk.zzoW()) {
            display.getRealMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
            n2 = displayMetrics.widthPixels;
        } else {
            try {
                n = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n2 = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n && n4 == n2;
    }

    public int zzS(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }
}

