/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import java.util.Collections;
import java.util.List;

public class Credential
implements SafeParcelable {
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int zzCY;
    private final String zzOS;
    private final String zzOT;
    private final String zzKI;
    private final String mName;
    private final Uri zzOU;
    private final List<IdToken> zzOV;
    private final String zzOW;
    private final String zzOX;

    Credential(int version, String internalCredentialId, String internalServerContext, String id2, String name, Uri profilePictureUri, List<IdToken> idTokens, String password, String accountType) {
        this.zzCY = version;
        this.zzOS = internalCredentialId;
        this.zzOT = internalServerContext;
        this.zzKI = zzu.zzu(id2);
        this.mName = name;
        this.zzOU = profilePictureUri;
        this.zzOV = idTokens == null ? Collections.emptyList() : Collections.unmodifiableList(idTokens);
        this.zzOW = password;
        this.zzOX = accountType;
    }

    public String zzkZ() {
        return this.zzOS;
    }

    public String zzla() {
        return this.zzOT;
    }

    public String getId() {
        return this.zzKI;
    }

    public String getName() {
        return this.mName;
    }

    public Uri getProfilePictureUri() {
        return this.zzOU;
    }

    public List<IdToken> zzlb() {
        return this.zzOV;
    }

    public String getPassword() {
        return this.zzOW;
    }

    public String getAccountType() {
        return this.zzOX;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public static class Builder {
        private final String zzKI;
        private String mName;
        private Uri zzOU;
        private List<IdToken> zzOV;
        private String zzOW;
        private String zzOX;
        private String zzOS;
        private String zzOT;

        public Builder(String id2) {
            this.zzKI = id2;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setPassword(String password) {
            this.zzOW = password;
            return this;
        }

        public Credential build() {
            if (!TextUtils.isEmpty((CharSequence)this.zzOW) && !TextUtils.isEmpty((CharSequence)this.zzOX)) {
                throw new IllegalStateException("Only one of password or accountType may be set");
            }
            return new Credential(1, this.zzOS, this.zzOT, this.zzKI, this.mName, this.zzOU, this.zzOV, this.zzOW, this.zzOX);
        }
    }
}

