/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.zzb;

public final class ConnectionResult
implements SafeParcelable {
    public static final ConnectionResult zzVG = new ConnectionResult(0, null);
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new zzb();
    final int zzCY;
    private final int zzTS;
    private final PendingIntent mPendingIntent;

    ConnectionResult(int versionCode, int statusCode, PendingIntent pendingIntent) {
        this.zzCY = versionCode;
        this.zzTS = statusCode;
        this.mPendingIntent = pendingIntent;
    }

    public ConnectionResult(int statusCode, PendingIntent pendingIntent) {
        this(1, statusCode, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    public boolean hasResolution() {
        return this.zzTS != 0 && this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzTS == 0;
    }

    public int getErrorCode() {
        return this.zzTS;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    static String getStatusString(int statusCode) {
        switch (statusCode) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 13: {
                return "CANCELED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
        }
        return "UNKNOWN_ERROR_CODE(" + statusCode + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult connectionResult = (ConnectionResult)o;
        return this.zzTS == connectionResult.zzTS && zzt.equal(this.mPendingIntent, connectionResult.mPendingIntent);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzTS, this.mPendingIntent);
    }

    public String toString() {
        return zzt.zzt(this).zzg("statusCode", ConnectionResult.getStatusString(this.zzTS)).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }
}

